/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.ObjectMapRetainStrategy;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.di.Inject;
import org.apache.commons.collections.map.ReferenceMap;

public class DefaultObjectMapRetainStrategy
implements ObjectMapRetainStrategy {
    private static final String WEAK_RETAIN_STRATEGY = "weak";
    private static final String SOFT_RETAIN_STRATEGY = "soft";
    private static final String HARD_RETAIN_STRATEGY = "hard";
    protected RuntimeProperties runtimeProperties;

    public DefaultObjectMapRetainStrategy(@Inject RuntimeProperties runtimeProperties) {
        this.runtimeProperties = runtimeProperties;
    }

    @Override
    public Map<Object, Persistent> createObjectMap() {
        String strategy = this.runtimeProperties.get("cayenne.server.object_retain_strategy");
        if (strategy == null || WEAK_RETAIN_STRATEGY.equals(strategy)) {
            return new ReferenceMap(0, 2);
        }
        if (SOFT_RETAIN_STRATEGY.equals(strategy)) {
            return new ReferenceMap(0, 1);
        }
        if (HARD_RETAIN_STRATEGY.equals(strategy)) {
            return new ReferenceMap(0, 0);
        }
        throw new CayenneRuntimeException("Unsupported retain strategy %s", strategy);
    }
}

