/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.graph.ArcCreateOperation;
import org.apache.cayenne.graph.ArcDeleteOperation;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.NodeCreateOperation;
import org.apache.cayenne.graph.NodeDeleteOperation;
import org.apache.cayenne.graph.NodeIdChangeOperation;
import org.apache.cayenne.graph.NodePropertyChangeOperation;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;

class ClientReturnDiffFilter
implements GraphChangeHandler {
    private List<GraphDiff> diffs;
    private EntityResolver resolver;

    ClientReturnDiffFilter(EntityResolver resolver) {
        this.resolver = resolver;
    }

    GraphDiff filter(GraphDiff in) {
        this.diffs = new ArrayList<GraphDiff>();
        in.apply(this);
        return new CompoundDiff(this.diffs);
    }

    @Override
    public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
        if (this.isClientArc(nodeId, targetNodeId, arcId)) {
            this.diffs.add(new ArcCreateOperation(nodeId, targetNodeId, arcId));
        }
    }

    @Override
    public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
        if (this.isClientArc(nodeId, targetNodeId, arcId)) {
            this.diffs.add(new ArcDeleteOperation(nodeId, targetNodeId, arcId));
        }
    }

    @Override
    public void nodeCreated(Object nodeId) {
        if (this.isClientNode(nodeId)) {
            this.diffs.add(new NodeCreateOperation(nodeId));
        }
    }

    @Override
    public void nodeIdChanged(Object nodeId, Object newId) {
        if (this.isClientNode(nodeId)) {
            this.diffs.add(new NodeIdChangeOperation(nodeId, newId));
        }
    }

    @Override
    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        if (this.isClientNode(nodeId)) {
            this.diffs.add(new NodePropertyChangeOperation(nodeId, property, oldValue, newValue));
        }
    }

    @Override
    public void nodeRemoved(Object nodeId) {
        if (this.isClientNode(nodeId)) {
            this.diffs.add(new NodeDeleteOperation(nodeId));
        }
    }

    private boolean isClientNode(Object id) {
        ObjectId oid = (ObjectId)id;
        return this.resolver.getObjEntity(oid.getEntityName()).isClientAllowed();
    }

    private boolean isClientArc(Object id, Object targetId, Object arcId) {
        ObjectId oid = (ObjectId)id;
        ObjEntity entity = this.resolver.getObjEntity(oid.getEntityName());
        if (!entity.isClientAllowed()) {
            return false;
        }
        if (entity.getRelationship(arcId.toString()).isRuntime()) {
            return false;
        }
        ObjectId targetOid = (ObjectId)targetId;
        ObjEntity targetEntity = this.resolver.getObjEntity(targetOid.getEntityName());
        return targetEntity.isClientAllowed();
    }
}

