/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.types.ValueObjectType;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.exp.TraversalHandler;
import org.apache.cayenne.exp.parser.ASTDbPath;
import org.apache.cayenne.exp.parser.ASTFunctionCall;
import org.apache.cayenne.exp.parser.ASTScalar;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.EntityResult;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.PathComponent;
import org.apache.cayenne.map.SQLResult;
import org.apache.cayenne.query.BaseQueryMetadata;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.PrefetchProcessor;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.util.CayenneMapEntry;

class SelectQueryMetadata
extends BaseQueryMetadata {
    private static final long serialVersionUID = 7465922769303943945L;
    Map<String, String> pathSplitAliases;
    boolean isSingleResultSetMapping;
    boolean suppressingDistinct;

    SelectQueryMetadata() {
    }

    @Override
    void copyFromInfo(QueryMetadata info) {
        super.copyFromInfo(info);
        this.pathSplitAliases = new HashMap<String, String>(info.getPathSplitAliases());
    }

    boolean resolve(Object root, EntityResolver resolver, SelectQuery<?> query) {
        if (super.resolve(root, resolver)) {
            if (this.cacheStrategy != null && this.cacheStrategy != QueryCacheStrategy.NO_CACHE) {
                this.cacheKey = this.makeCacheKey(query, resolver);
            }
            this.resolveAutoAliases(query);
            this.buildResultSetMappingForColumns(query, resolver);
            this.isSingleResultSetMapping = query.canReturnScalarValue() && super.isSingleResultSetMapping();
            return true;
        }
        return false;
    }

    private String makeCacheKey(SelectQuery<?> query, EntityResolver resolver) {
        StringBuilder key = new StringBuilder();
        ToCacheKeyTraversalHandler traversalHandler = null;
        ObjEntity entity = this.getObjEntity();
        if (entity != null) {
            key.append(entity.getName());
        } else if (this.dbEntity != null) {
            key.append("db:").append(this.dbEntity.getName());
        }
        if (query.getColumns() != null && !query.getColumns().isEmpty()) {
            traversalHandler = new ToCacheKeyTraversalHandler(resolver.getValueObjectTypeRegistry(), key);
            for (Property property : query.getColumns()) {
                key.append("/c:");
                property.getExpression().traverse(traversalHandler);
            }
        }
        if (query.getQualifier() != null) {
            key.append('/');
            if (traversalHandler == null) {
                traversalHandler = new ToCacheKeyTraversalHandler(resolver.getValueObjectTypeRegistry(), key);
            }
            query.getQualifier().traverse(traversalHandler);
        }
        if (!query.getOrderings().isEmpty()) {
            for (Ordering ordering : query.getOrderings()) {
                key.append('/').append(ordering.getSortSpecString());
                if (!ordering.isAscending()) {
                    key.append(":d");
                }
                if (!ordering.isCaseInsensitive()) continue;
                key.append(":i");
            }
        }
        if (query.getFetchOffset() > 0 || query.getFetchLimit() > 0) {
            key.append('/');
            if (query.getFetchOffset() > 0) {
                key.append('o').append(query.getFetchOffset());
            }
            if (query.getFetchLimit() > 0) {
                key.append('l').append(query.getFetchLimit());
            }
        }
        if (query.getPrefetchTree() != null) {
            query.getPrefetchTree().traverse(new ToCacheKeyPrefetchProcessor(key));
        }
        return key.toString();
    }

    private void resolveAutoAliases(SelectQuery<?> query) {
        Expression qualifier = query.getQualifier();
        if (qualifier != null) {
            this.resolveAutoAliases(qualifier);
        }
    }

    private void resolveAutoAliases(Expression expression) {
        Map<String, String> aliases = expression.getPathAliases();
        if (!aliases.isEmpty()) {
            if (this.pathSplitAliases == null) {
                this.pathSplitAliases = new HashMap<String, String>();
            }
            this.pathSplitAliases.putAll(aliases);
        }
        int len = expression.getOperandCount();
        for (int i = 0; i < len; ++i) {
            Object operand = expression.getOperand(i);
            if (!(operand instanceof Expression)) continue;
            this.resolveAutoAliases((Expression)operand);
        }
    }

    @Override
    public Map<String, String> getPathSplitAliases() {
        return this.pathSplitAliases != null ? this.pathSplitAliases : Collections.emptyMap();
    }

    public void addPathSplitAliases(String path, String ... aliases) {
        if (aliases == null) {
            throw new NullPointerException("Null aliases");
        }
        if (aliases.length == 0) {
            throw new IllegalArgumentException("No aliases specified");
        }
        if (this.pathSplitAliases == null) {
            this.pathSplitAliases = new HashMap<String, String>();
        }
        for (String alias : aliases) {
            this.pathSplitAliases.put(alias, path);
        }
    }

    private void buildResultSetMappingForColumns(SelectQuery<?> query, EntityResolver resolver) {
        if (query.getColumns() == null || query.getColumns().isEmpty()) {
            return;
        }
        SQLResult result = new SQLResult();
        for (Property<?> column : query.getColumns()) {
            Expression exp = column.getExpression();
            String name = column.getName() == null ? exp.expName() : column.getName();
            boolean fullObject = false;
            if (exp.getType() == 26) {
                Expression dbPath = this.getObjEntity().translateToDbPath(exp);
                DbRelationship rel = this.findRelationByPath(this.dbEntity, dbPath);
                if (rel != null && !rel.isToMany()) {
                    fullObject = true;
                }
            } else if (exp.getType() == 47) {
                fullObject = true;
            }
            if (fullObject) {
                if (this.getPageSize() > 0) {
                    result.addEntityResult(this.buildEntityIdResultForColumn(column, resolver));
                    continue;
                }
                result.addEntityResult(this.buildEntityResultForColumn(query, column, resolver));
                continue;
            }
            result.addColumnResult(name);
        }
        this.resultSetMapping = result.getResolvedComponents(resolver);
    }

    private EntityResult buildEntityIdResultForColumn(Property<?> column, EntityResolver resolver) {
        EntityResult result = new EntityResult(column.getType());
        DbEntity entity = resolver.getObjEntity(column.getType()).getDbEntity();
        for (DbAttribute attribute : entity.getPrimaryKeys()) {
            result.addDbField(attribute.getName(), attribute.getName());
        }
        return result;
    }

    private DbRelationship findRelationByPath(DbEntity entity, Expression exp) {
        DbRelationship r = null;
        for (PathComponent<DbAttribute, DbRelationship> component : entity.resolvePath(exp, this.getPathSplitAliases())) {
            r = component.getRelationship();
        }
        return r;
    }

    private EntityResult buildEntityResultForColumn(SelectQuery<?> query, Property<?> column, EntityResolver resolver) {
        final EntityResult result = new EntityResult(column.getType());
        PropertyVisitor visitor = new PropertyVisitor(){

            @Override
            public boolean visitAttribute(AttributeProperty property) {
                ObjAttribute oa = property.getAttribute();
                Iterator<CayenneMapEntry> dbPathIterator = oa.getDbPathIterator();
                while (dbPathIterator.hasNext()) {
                    CayenneMapEntry pathPart = dbPathIterator.next();
                    if (!(pathPart instanceof DbAttribute)) continue;
                    result.addDbField(pathPart.getName(), pathPart.getName());
                }
                return true;
            }

            @Override
            public boolean visitToMany(ToManyProperty property) {
                return true;
            }

            @Override
            public boolean visitToOne(ToOneProperty property) {
                DbRelationship dbRel = property.getRelationship().getDbRelationships().get(0);
                List<DbJoin> joins = dbRel.getJoins();
                for (DbJoin join : joins) {
                    if (join.getSource().isPrimaryKey()) continue;
                    result.addDbField(join.getSource().getName(), join.getSource().getName());
                }
                return true;
            }
        };
        ObjEntity oe = resolver.getObjEntity(column.getType());
        DbEntity table = oe.getDbEntity();
        for (DbAttribute dba : table.getPrimaryKeys()) {
            result.addDbField(dba.getName(), dba.getName());
        }
        ClassDescriptor descriptor = resolver.getClassDescriptor(oe.getName());
        descriptor.visitAllProperties(visitor);
        if (query.getPrefetchTree() != null) {
            for (PrefetchTreeNode prefetch : query.getPrefetchTree().adjacentJointNodes()) {
                Expression prefetchExp = ExpressionFactory.exp(prefetch.getPath(), new Object[0]);
                ASTDbPath dbPrefetch = (ASTDbPath)oe.translateToDbPath(prefetchExp);
                DbRelationship r = this.findRelationByPath(table, dbPrefetch);
                if (r == null) {
                    throw new CayenneRuntimeException("Invalid joint prefetch '%s' for entity: %s", prefetch, oe.getName());
                }
                ObjRelationship targetRel = (ObjRelationship)prefetchExp.evaluate(oe);
                ObjEntity targetEntity = targetRel.getTargetEntity();
                prefetch.setEntityName(targetRel.getSourceEntity().getName());
                String labelPrefix = dbPrefetch.getPath();
                HashSet<String> seenNames = new HashSet<String>();
                for (ObjAttribute oa : targetEntity.getAttributes()) {
                    Iterator<CayenneMapEntry> dbPathIterator = oa.getDbPathIterator();
                    while (dbPathIterator.hasNext()) {
                        DbAttribute attribute;
                        CayenneMapEntry pathPart = dbPathIterator.next();
                        if (!(pathPart instanceof DbAttribute) || !seenNames.add((attribute = (DbAttribute)pathPart).getName())) continue;
                        result.addDbField(labelPrefix + '.' + attribute.getName(), labelPrefix + '.' + attribute.getName());
                    }
                }
                DbEntity targetDbEntity = r.getTargetEntity();
                for (DbAttribute attribute : targetDbEntity.getAttributes()) {
                    if (!seenNames.add(attribute.getName())) continue;
                    result.addDbField(labelPrefix + '.' + attribute.getName(), labelPrefix + '.' + attribute.getName());
                }
            }
        }
        return result;
    }

    @Override
    public boolean isSingleResultSetMapping() {
        return this.isSingleResultSetMapping;
    }

    @Override
    public boolean isSuppressingDistinct() {
        return this.suppressingDistinct;
    }

    public void setSuppressingDistinct(boolean suppressingDistinct) {
        this.suppressingDistinct = suppressingDistinct;
    }

    static class ToCacheKeyPrefetchProcessor
    implements PrefetchProcessor {
        StringBuilder out;

        ToCacheKeyPrefetchProcessor(StringBuilder out) {
            this.out = out;
        }

        @Override
        public boolean startPhantomPrefetch(PrefetchTreeNode node) {
            return true;
        }

        @Override
        public boolean startDisjointPrefetch(PrefetchTreeNode node) {
            this.out.append("/pd:").append(node.getPath());
            return true;
        }

        @Override
        public boolean startDisjointByIdPrefetch(PrefetchTreeNode node) {
            this.out.append("/pi:").append(node.getPath());
            return true;
        }

        @Override
        public boolean startJointPrefetch(PrefetchTreeNode node) {
            this.out.append("/pj:").append(node.getPath());
            return true;
        }

        @Override
        public boolean startUnknownPrefetch(PrefetchTreeNode node) {
            this.out.append("/pu:").append(node.getPath());
            return true;
        }

        @Override
        public void finishPrefetch(PrefetchTreeNode node) {
        }
    }

    static class ToCacheKeyTraversalHandler
    implements TraversalHandler {
        private ValueObjectTypeRegistry registry;
        private StringBuilder out;

        ToCacheKeyTraversalHandler(ValueObjectTypeRegistry registry, StringBuilder out) {
            this.registry = registry;
            this.out = out;
        }

        @Override
        public void finishedChild(Expression node, int childIndex, boolean hasMoreChildren) {
            this.out.append(',');
        }

        @Override
        public void startNode(Expression node, Expression parentNode) {
            if (node.getType() == 45) {
                this.out.append(((ASTFunctionCall)node).getFunctionName()).append('(');
            } else {
                this.out.append(node.getType()).append('(');
            }
        }

        @Override
        public void endNode(Expression node, Expression parentNode) {
            this.out.append(')');
        }

        @Override
        public void objectNode(Object leaf, Expression parentNode) {
            ValueObjectType<?, ?> valueObjectType;
            if (leaf == null) {
                this.out.append("null");
                return;
            }
            if (leaf instanceof ASTScalar) {
                leaf = ((ASTScalar)leaf).getValue();
            } else if (leaf instanceof Object[]) {
                for (Object value : (Object[])leaf) {
                    this.objectNode(value, parentNode);
                    this.out.append(',');
                }
                return;
            }
            if (leaf instanceof Persistent) {
                ObjectId id = ((Persistent)leaf).getObjectId();
                Object encode = id != null ? id : leaf;
                this.out.append(encode);
            } else if (leaf instanceof Enum) {
                Enum e = (Enum)leaf;
                this.out.append("e:").append(leaf.getClass().getName()).append(':').append(e.ordinal());
            } else if (this.registry == null || (valueObjectType = this.registry.getValueType(leaf.getClass())) == null) {
                this.out.append(leaf);
            } else {
                this.out.append(valueObjectType.toCacheKey(leaf));
            }
        }
    }
}

