/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.cayenne.access.translator.select.JoinStack;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.JoinType;
import org.apache.cayenne.util.Util;

public final class JoinTreeNode {
    private String targetTableAlias;
    private String sourceTableAlias;
    private DbRelationship relationship;
    private String alias;
    private JoinType joinType;
    private Collection<JoinTreeNode> children;
    private JoinStack joinProcessor;
    private JoinTreeNode parent;

    JoinTreeNode(JoinStack joinProcessor) {
        this.joinProcessor = joinProcessor;
    }

    JoinTreeNode(JoinStack joinProcessor, DbRelationship relationship, JoinType joinType, String alias, JoinTreeNode parent) {
        this(joinProcessor);
        this.relationship = relationship;
        this.alias = alias;
        this.joinType = joinType;
        this.parent = parent;
    }

    int size() {
        int i = 1;
        if (this.children != null) {
            for (JoinTreeNode child : this.children) {
                i += child.size();
            }
        }
        return i;
    }

    public Collection<JoinTreeNode> getChildren() {
        return this.children != null ? this.children : Collections.emptyList();
    }

    JoinTreeNode findOrCreateChild(DbRelationship relationship, JoinType joinType, String alias) {
        if (this.children == null) {
            this.children = new ArrayList<JoinTreeNode>(4);
        } else {
            for (JoinTreeNode child : this.children) {
                if (!child.equals(relationship, joinType, alias)) continue;
                return child;
            }
        }
        JoinTreeNode child = new JoinTreeNode(this.joinProcessor, relationship, joinType, alias, this);
        child.setSourceTableAlias(this.targetTableAlias);
        child.setTargetTableAlias(this.joinProcessor.newAlias());
        this.children.add(child);
        return child;
    }

    private boolean equals(DbRelationship relationship, JoinType joinType, String alias) {
        return this.relationship == relationship && this.joinType == joinType && Util.nullSafeEquals(this.alias, alias);
    }

    public String getTargetTableAlias() {
        return this.targetTableAlias;
    }

    void setTargetTableAlias(String targetTableAlias) {
        this.targetTableAlias = targetTableAlias;
    }

    public String getSourceTableAlias() {
        return this.sourceTableAlias;
    }

    void setSourceTableAlias(String sourceTableAlias) {
        this.sourceTableAlias = sourceTableAlias;
    }

    public DbRelationship getRelationship() {
        return this.relationship;
    }

    String getAlias() {
        return this.alias;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public JoinTreeNode getParent() {
        return this.parent;
    }
}

