/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import org.apache.cayenne.access.translator.select.PathComponents;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.JoinType;

class TableTreeNode {
    private final PathComponents attributePath;
    private final DbEntity entity;
    private final String tableAlias;
    private final JoinType joinType;
    private final DbRelationship relationship;

    TableTreeNode(DbEntity entity, String tableAlias) {
        this.attributePath = new PathComponents("");
        this.entity = entity;
        this.tableAlias = tableAlias;
        this.relationship = null;
        this.joinType = null;
    }

    TableTreeNode(String path, DbRelationship relationship, String tableAlias, JoinType joinType) {
        this.attributePath = new PathComponents(path);
        this.entity = relationship.getTargetEntity();
        this.tableAlias = tableAlias;
        this.relationship = relationship;
        this.joinType = joinType;
    }

    public PathComponents getAttributePath() {
        return this.attributePath;
    }

    public DbEntity getEntity() {
        return this.entity;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public DbRelationship getRelationship() {
        return this.relationship;
    }
}

