/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import org.apache.cayenne.configuration.xml.DbKeyGeneratorHandler;
import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class DbEntityHandler
extends NamespaceAwareNestedTagHandler {
    private static final String DB_ENTITY_TAG = "db-entity";
    private static final String DB_ATTRIBUTE_TAG = "db-attribute";
    private static final String DB_KEY_GENERATOR_TAG = "db-key-generator";
    private static final String QUALIFIER_TAG = "qualifier";
    private DataMap dataMap;
    private DbEntity entity;
    private DbAttribute lastAttribute;

    public DbEntityHandler(NamespaceAwareNestedTagHandler parentHandler, DataMap dataMap) {
        super(parentHandler);
        this.dataMap = dataMap;
    }

    @Override
    protected boolean processElement(String namespaceURI, String localName, Attributes attributes) throws SAXException {
        switch (localName) {
            case "db-entity": {
                this.createDbEntity(attributes);
                return true;
            }
            case "db-attribute": {
                this.createDbAttribute(attributes);
                return true;
            }
            case "qualifier": {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void processCharData(String localName, String data) {
        switch (localName) {
            case "qualifier": {
                this.createQualifier(data);
            }
        }
    }

    @Override
    protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String qName, Attributes attributes) {
        switch (localName) {
            case "db-key-generator": {
                return new DbKeyGeneratorHandler(this, this.entity);
            }
        }
        return super.createChildTagHandler(namespaceURI, localName, qName, attributes);
    }

    private void createDbEntity(Attributes attributes) {
        String name = attributes.getValue("name");
        this.entity = new DbEntity(name);
        this.entity.setSchema(attributes.getValue("schema"));
        this.entity.setCatalog(attributes.getValue("catalog"));
        this.dataMap.addDbEntity(this.entity);
    }

    private void createDbAttribute(Attributes attributes) {
        String scale;
        String pseudoPrecision;
        String precision;
        String name = attributes.getValue("name");
        String type = attributes.getValue("type");
        this.lastAttribute = new DbAttribute(name);
        this.lastAttribute.setType(TypesMapping.getSqlTypeByName(type));
        this.entity.addAttribute(this.lastAttribute);
        String length = attributes.getValue("length");
        if (length != null) {
            this.lastAttribute.setMaxLength(Integer.parseInt(length));
        }
        if ((precision = attributes.getValue("attributePrecision")) != null) {
            this.lastAttribute.setAttributePrecision(Integer.parseInt(precision));
        }
        if ((pseudoPrecision = attributes.getValue("precision")) != null) {
            this.lastAttribute.setScale(Integer.parseInt(pseudoPrecision));
        }
        if ((scale = attributes.getValue("scale")) != null) {
            this.lastAttribute.setScale(Integer.parseInt(scale));
        }
        this.lastAttribute.setPrimaryKey("true".equalsIgnoreCase(attributes.getValue("isPrimaryKey")));
        this.lastAttribute.setMandatory("true".equalsIgnoreCase(attributes.getValue("isMandatory")));
        this.lastAttribute.setGenerated("true".equalsIgnoreCase(attributes.getValue("isGenerated")));
    }

    private void createQualifier(String qualifier) {
        if (Util.isBlank(qualifier)) {
            return;
        }
        if (this.entity != null) {
            this.entity.setQualifier(ExpressionFactory.exp(qualifier, new Object[0]));
        }
    }

    public DbEntity getEntity() {
        return this.entity;
    }

    public DbAttribute getLastAttribute() {
        return this.lastAttribute;
    }
}

