/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.cayenne.access.translator.select.PathComponents;
import org.apache.cayenne.access.translator.select.PathTranslationResult;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.Entity;

abstract class PathProcessor<T extends Entity>
implements PathTranslationResult {
    public static final char OUTER_JOIN_INDICATOR = '+';
    public static final char SPLIT_PATH_INDICATOR = '#';
    protected final Map<String, String> pathSplitAliases;
    protected final TranslatorContext context;
    protected final List<String> attributePaths;
    protected final List<DbAttribute> attributes;
    protected final StringBuilder currentDbPath;
    protected boolean lastComponent;
    private boolean isOuterJoin;
    protected T entity;
    protected DbRelationship relationship;
    protected String currentAlias;

    public PathProcessor(TranslatorContext context, T entity) {
        this.context = Objects.requireNonNull(context);
        this.entity = (Entity)Objects.requireNonNull(entity);
        this.pathSplitAliases = context.getMetadata().getPathSplitAliases();
        this.currentDbPath = new StringBuilder();
        this.attributes = new ArrayList<DbAttribute>(1);
        this.attributePaths = new ArrayList<String>(1);
    }

    public PathTranslationResult process(String path) {
        PathComponents components = new PathComponents(path);
        String[] rawComponents = components.getAll();
        for (int i = 0; i < rawComponents.length; ++i) {
            String next = rawComponents[i];
            this.isOuterJoin = false;
            this.lastComponent = i == rawComponents.length - 1;
            String alias = this.pathSplitAliases.get(next);
            if (alias != null) {
                this.currentAlias = next;
                this.processAliasedAttribute(next, alias);
                this.currentAlias = null;
                continue;
            }
            if (next.charAt(next.length() - 1) == '+') {
                this.isOuterJoin = true;
                next = next.substring(0, next.length() - 1);
            }
            this.processNormalAttribute(next);
        }
        return this;
    }

    protected void addAttribute(String path, DbAttribute attribute) {
        this.attributePaths.add(path);
        this.attributes.add(attribute);
    }

    protected abstract void processAliasedAttribute(String var1, String var2);

    protected abstract void processNormalAttribute(String var1);

    @Override
    public List<DbAttribute> getDbAttributes() {
        return this.attributes;
    }

    @Override
    public List<String> getAttributePaths() {
        return this.attributePaths;
    }

    @Override
    public Optional<DbRelationship> getDbRelationship() {
        if (this.relationship == null) {
            return Optional.empty();
        }
        return Optional.of(this.relationship);
    }

    @Override
    public Optional<Embeddable> getEmbeddable() {
        return Optional.empty();
    }

    @Override
    public String getFinalPath() {
        return this.currentDbPath.toString();
    }

    protected void appendCurrentPath(String nextSegment) {
        if (this.currentDbPath.length() > 0) {
            this.currentDbPath.append('.');
        }
        this.currentDbPath.append(nextSegment);
        if (this.currentAlias != null) {
            this.currentDbPath.append('#').append(this.currentAlias);
        }
        if (this.isOuterJoin) {
            this.currentDbPath.append('+');
        }
    }

    public boolean isOuterJoin() {
        return this.isOuterJoin;
    }
}

