/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.sqlbuilder.NodeBuilder;
import org.apache.cayenne.access.sqlbuilder.SQLBuilder;
import org.apache.cayenne.access.sqlbuilder.SQLGenerationContext;
import org.apache.cayenne.access.sqlbuilder.SelectBuilder;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.translator.DbAttributeBinding;
import org.apache.cayenne.access.translator.select.PathTranslator;
import org.apache.cayenne.access.translator.select.QualifierTranslator;
import org.apache.cayenne.access.translator.select.ResultNodeDescriptor;
import org.apache.cayenne.access.translator.select.TableTree;
import org.apache.cayenne.access.translator.select.TranslatableQueryWrapper;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.exp.property.Property;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.EntityResult;
import org.apache.cayenne.map.SQLResult;
import org.apache.cayenne.query.QueryMetadata;

public class TranslatorContext
implements SQLGenerationContext {
    private final TableTree tableTree;
    private final List<ColumnDescriptor> columnDescriptors;
    private final Collection<DbAttributeBinding> bindings;
    private final TranslatableQueryWrapper query;
    private final QueryMetadata metadata;
    private final EntityResolver resolver;
    private final DbAdapter adapter;
    private final QuotingStrategy quotingStrategy;
    private final SelectBuilder selectBuilder;
    private final QualifierTranslator qualifierTranslator;
    private final PathTranslator pathTranslator;
    private final TranslatorContext parentContext;
    private final List<ResultNodeDescriptor> resultNodeList;
    private Node qualifierNode;
    private boolean skipSQLGeneration;
    private String finalSQL;
    private boolean distinctSuppression;
    private int rootSegmentEnd;
    private boolean appendResultToRoot;
    private SQLResult sqlResult;
    private EntityResult rootEntityResult;

    TranslatorContext(TranslatableQueryWrapper query, DbAdapter adapter, EntityResolver resolver, TranslatorContext parentContext) {
        this.query = query;
        this.adapter = adapter;
        this.resolver = resolver;
        this.metadata = query.getMetaData(resolver);
        this.parentContext = parentContext;
        this.tableTree = new TableTree(this.metadata.getDbEntity(), parentContext == null ? null : parentContext.getTableTree());
        this.columnDescriptors = new ArrayList<ColumnDescriptor>();
        this.bindings = new ArrayList<DbAttributeBinding>(4);
        this.selectBuilder = SQLBuilder.select(new NodeBuilder[0]);
        this.pathTranslator = new PathTranslator(this);
        this.qualifierTranslator = new QualifierTranslator(this);
        this.quotingStrategy = adapter.getQuotingStrategy();
        this.resultNodeList = new LinkedList<ResultNodeDescriptor>();
        if (query.needsResultSetMapping()) {
            this.sqlResult = new SQLResult();
        }
    }

    void markDescriptorStart(DescriptorType type) {
        if (type == DescriptorType.PREFETCH) {
            this.appendResultToRoot = true;
        }
    }

    void markDescriptorEnd(DescriptorType type) {
        if (type == DescriptorType.ROOT) {
            this.rootSegmentEnd = this.resultNodeList.size() - 1;
        } else if (type == DescriptorType.PREFETCH) {
            this.appendResultToRoot = false;
        }
    }

    SelectBuilder getSelectBuilder() {
        return this.selectBuilder;
    }

    Collection<ColumnDescriptor> getColumnDescriptors() {
        return this.columnDescriptors;
    }

    @Override
    public Collection<DbAttributeBinding> getBindings() {
        return this.bindings;
    }

    TableTree getTableTree() {
        return this.tableTree;
    }

    QualifierTranslator getQualifierTranslator() {
        return this.qualifierTranslator;
    }

    PathTranslator getPathTranslator() {
        return this.pathTranslator;
    }

    int getTableCount() {
        return this.tableTree.getNodeCount();
    }

    TranslatableQueryWrapper getQuery() {
        return this.query;
    }

    QueryMetadata getMetadata() {
        return this.metadata;
    }

    EntityResolver getResolver() {
        return this.resolver;
    }

    @Override
    public DbAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public DbEntity getRootDbEntity() {
        return this.metadata.getDbEntity();
    }

    @Override
    public QuotingStrategy getQuotingStrategy() {
        return this.quotingStrategy;
    }

    void setDistinctSuppression(boolean distinctSuppression) {
        this.distinctSuppression = distinctSuppression;
    }

    boolean isDistinctSuppression() {
        return this.distinctSuppression;
    }

    void setFinalSQL(String SQL) {
        this.finalSQL = SQL;
    }

    String getFinalSQL() {
        return this.finalSQL;
    }

    List<ResultNodeDescriptor> getResultNodeList() {
        return this.resultNodeList;
    }

    ResultNodeDescriptor addResultNode(Node node) {
        return this.addResultNode(node, false, null, null);
    }

    ResultNodeDescriptor addResultNode(Node node, String dataRowKey) {
        return this.addResultNode(node, true, null, dataRowKey);
    }

    ResultNodeDescriptor addResultNode(Node node, boolean inDataRow, Property<?> property, String dataRowKey) {
        ResultNodeDescriptor resultNode = new ResultNodeDescriptor(node, inDataRow, property, dataRowKey);
        if (this.appendResultToRoot) {
            this.resultNodeList.add(this.rootSegmentEnd + 1, resultNode);
        } else {
            this.resultNodeList.add(resultNode);
        }
        return resultNode;
    }

    TranslatorContext getParentContext() {
        return this.parentContext;
    }

    void setSkipSQLGeneration(boolean skipSQLGeneration) {
        this.skipSQLGeneration = skipSQLGeneration;
    }

    boolean isSkipSQLGeneration() {
        return this.skipSQLGeneration;
    }

    SQLResult getSqlResult() {
        return this.sqlResult;
    }

    void setRootEntityResult(EntityResult rootEntityResult) {
        this.rootEntityResult = rootEntityResult;
    }

    EntityResult getRootEntityResult() {
        return this.rootEntityResult;
    }

    void setQualifierNode(Node qualifierNode) {
        this.qualifierNode = qualifierNode;
    }

    Node getQualifierNode() {
        return this.qualifierNode;
    }

    static enum DescriptorType {
        ROOT,
        PREFETCH,
        OTHER;

    }
}

