/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.h2;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.cayenne.configuration.server.DbAdapterDetector;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.h2.H2Adapter;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;

public class H2Sniffer
implements DbAdapterDetector {
    protected AdhocObjectFactory objectFactory;

    public H2Sniffer(@Inject AdhocObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Override
    public DbAdapter createAdapter(DatabaseMetaData md) throws SQLException {
        String dbName = md.getDatabaseProductName();
        if (dbName == null || !dbName.toUpperCase().contains("H2")) {
            return null;
        }
        return (DbAdapter)this.objectFactory.newInstance(DbAdapter.class, H2Adapter.class.getName());
    }
}

