/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import org.apache.commons.imaging.formats.tiff.TiffRasterDataType;
import org.apache.commons.imaging.formats.tiff.TiffRasterStatistics;

public abstract class TiffRasterData {
    protected final int width;
    protected final int height;
    protected final int samplesPerPixel;
    protected final int nCells;
    protected final int planarOffset;

    public TiffRasterData(int width, int height, int samplesPerPixel) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Raster dimensions less than or equal to zero are not supported");
        }
        if (samplesPerPixel <= 0) {
            throw new IllegalArgumentException("Raster samples-per-pixel specification must be at least 1");
        }
        this.width = width;
        this.height = height;
        this.samplesPerPixel = samplesPerPixel;
        this.nCells = width * height * samplesPerPixel;
        this.planarOffset = width * height;
    }

    protected final int checkCoordinatesAndComputeIndex(int x, int y, int i) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            throw new IllegalArgumentException("Coordinates out of range (" + x + ", " + y + ")");
        }
        if (i < 0 || i >= this.samplesPerPixel) {
            throw new IllegalArgumentException("Sample index out of range, value " + i + " where valid range is (0," + (this.samplesPerPixel - 1) + ")");
        }
        return y * this.width + x + i * this.planarOffset;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getSamplesPerPixel() {
        return this.samplesPerPixel;
    }

    public abstract TiffRasterDataType getDataType();

    public abstract void setValue(int var1, int var2, float var3);

    public abstract void setValue(int var1, int var2, int var3, float var4);

    public abstract float getValue(int var1, int var2);

    public abstract float getValue(int var1, int var2, int var3);

    public abstract void setIntValue(int var1, int var2, int var3);

    public abstract void setIntValue(int var1, int var2, int var3, int var4);

    public abstract int getIntValue(int var1, int var2);

    public abstract int getIntValue(int var1, int var2, int var3);

    public abstract TiffRasterStatistics getSimpleStatistics();

    public abstract TiffRasterStatistics getSimpleStatistics(float var1);

    public abstract float[] getData();

    public abstract int[] getIntData();
}

