/*
 * Decompiled with CFR 0.152.
 */
package org.apache.continuum.builder.distributed.executor;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.continuum.builder.distributed.executor.DistributedBuildTaskExecutor;
import org.apache.continuum.dao.BuildDefinitionDao;
import org.apache.continuum.dao.BuildResultDao;
import org.apache.continuum.dao.ProjectDao;
import org.apache.continuum.dao.ProjectScmRootDao;
import org.apache.continuum.distributed.transport.slave.SlaveBuildAgentTransportClient;
import org.apache.continuum.model.project.ProjectScmRoot;
import org.apache.continuum.model.repository.LocalRepository;
import org.apache.continuum.taskqueue.PrepareBuildProjectsTask;
import org.apache.continuum.utils.ContinuumUtils;
import org.apache.continuum.utils.ProjectSorter;
import org.apache.continuum.utils.build.BuildTrigger;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.configuration.ConfigurationService;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.scm.ChangeFile;
import org.apache.maven.continuum.model.scm.ChangeSet;
import org.apache.maven.continuum.model.scm.ScmResult;
import org.apache.maven.continuum.store.ContinuumStoreException;
import org.codehaus.plexus.taskqueue.Task;
import org.codehaus.plexus.taskqueue.execution.TaskExecutionException;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributedBuildProjectTaskExecutor
implements DistributedBuildTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(DistributedBuildProjectTaskExecutor.class);
    private String buildAgentUrl;
    private long startTime;
    private long endTime;
    private ProjectDao projectDao;
    private ProjectScmRootDao projectScmRootDao;
    private BuildDefinitionDao buildDefinitionDao;
    private BuildResultDao buildResultDao;
    private ConfigurationService configurationService;

    public void setBuildAgentUrl(String buildAgentUrl) {
        this.buildAgentUrl = buildAgentUrl;
    }

    public String getBuildAgentUrl() {
        return this.buildAgentUrl;
    }

    public void executeTask(Task task) throws TaskExecutionException {
        PrepareBuildProjectsTask prepareBuildTask = (PrepareBuildProjectsTask)task;
        try {
            SlaveBuildAgentTransportClient client = new SlaveBuildAgentTransportClient(new URL(this.buildAgentUrl), "", this.configurationService.getSharedSecretPassword());
            log.info("initializing buildContext for projectGroupId=" + prepareBuildTask.getProjectGroupId());
            List<Map<String, Object>> buildContext = this.initializeBuildContext(prepareBuildTask.getProjectsBuildDefinitionsMap(), prepareBuildTask.getBuildTrigger(), prepareBuildTask.getScmRootAddress(), prepareBuildTask.getProjectScmRootId());
            this.startTime = System.currentTimeMillis();
            client.buildProjects(buildContext);
            this.endTime = System.currentTimeMillis();
        }
        catch (MalformedURLException e) {
            log.error("Invalid URL " + this.buildAgentUrl + ", not building");
            throw new TaskExecutionException("Invalid URL " + this.buildAgentUrl, (Throwable)e);
        }
        catch (Exception e) {
            log.error("Error occurred while building task", (Throwable)e);
            this.endTime = System.currentTimeMillis();
            this.createResult(prepareBuildTask, ContinuumUtils.throwableToString((Throwable)e));
        }
    }

    private List<Map<String, Object>> initializeBuildContext(Map<Integer, Integer> projectsAndBuildDefinitions, BuildTrigger buildTrigger, String scmRootAddress, int scmRootId) throws ContinuumException {
        ArrayList<Map<String, Object>> buildContext = new ArrayList<Map<String, Object>>();
        try {
            ProjectScmRoot scmRoot = this.projectScmRootDao.getProjectScmRoot(scmRootId);
            List projects = this.projectDao.getProjectsWithDependenciesByGroupId(scmRoot.getProjectGroup().getId());
            List sortedProjects = ProjectSorter.getSortedProjects((Collection)projects, null);
            for (Project project : sortedProjects) {
                LocalRepository localRepo;
                if (!projectsAndBuildDefinitions.containsKey(project.getId())) continue;
                int buildDefinitionId = projectsAndBuildDefinitions.get(project.getId());
                BuildDefinition buildDef = this.buildDefinitionDao.getBuildDefinition(buildDefinitionId);
                BuildResult buildResult = this.buildResultDao.getLatestBuildResultForProject(project.getId());
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("project-group-id", project.getProjectGroup().getId());
                context.put("project-group-name", project.getProjectGroup().getName());
                context.put("scm-root-id", scmRootId);
                context.put("scm-root-address", scmRootAddress);
                context.put("project-id", project.getId());
                context.put("project-name", project.getName());
                context.put("project-version", project.getVersion());
                context.put("executor-id", project.getExecutorId());
                context.put("build-number", project.getBuildNumber());
                context.put("scm-url", project.getScmUrl());
                context.put("project-state", project.getState());
                if (buildResult != null) {
                    context.put("latest-update-date", new Date(buildResult.getLastChangedDate()));
                }
                if ((localRepo = project.getProjectGroup().getLocalRepository()) != null) {
                    context.put("local-repository", localRepo.getName());
                } else {
                    context.put("local-repository", "");
                }
                if (project.getScmUsername() == null) {
                    context.put("scm-username", "");
                } else {
                    context.put("scm-username", project.getScmUsername());
                }
                if (project.getScmPassword() == null) {
                    context.put("scm-password", "");
                } else {
                    context.put("scm-password", project.getScmPassword());
                }
                if (project.getScmTag() != null) {
                    context.put("scm-tag", project.getScmTag());
                } else {
                    context.put("scm-tag", "");
                }
                context.put("builddefinition-id", buildDefinitionId);
                String buildDefinitionLabel = buildDef.getDescription();
                if (StringUtils.isEmpty((String)buildDefinitionLabel)) {
                    buildDefinitionLabel = buildDef.getGoals();
                }
                context.put("builddefinition-label", buildDefinitionLabel);
                context.put("build-file", buildDef.getBuildFile());
                if (buildDef.getGoals() == null) {
                    context.put("goals", "");
                } else {
                    context.put("goals", buildDef.getGoals());
                }
                if (buildDef.getArguments() == null) {
                    context.put("arguments", "");
                } else {
                    context.put("arguments", buildDef.getArguments());
                }
                context.put("trigger", buildTrigger.getTrigger());
                if (buildTrigger.getTrigger() == 1) {
                    context.put("username", buildTrigger.getTriggeredBy());
                } else {
                    context.put("username", buildDef.getSchedule().getName());
                }
                context.put("build-fresh", buildDef.isBuildFresh());
                context.put("always-build", buildDef.isAlwaysBuild());
                context.put("old-scm-changes", this.getOldScmChanges(project.getId(), buildDefinitionId));
                context.put("build-agent-url", this.buildAgentUrl);
                context.put("max-job-exec-time", buildDef.getSchedule().getMaxJobExecutionTime());
                buildContext.add(context);
            }
            return buildContext;
        }
        catch (ContinuumStoreException e) {
            throw new ContinuumException("Error while initializing build context", (Throwable)e);
        }
    }

    private void createResult(PrepareBuildProjectsTask task, String error) throws TaskExecutionException {
        try {
            ProjectScmRoot scmRoot = this.projectScmRootDao.getProjectScmRootByProjectGroupAndScmRootAddress(task.getProjectGroupId(), task.getScmRootAddress());
            if (scmRoot.getState() == 8) {
                scmRoot.setState(4);
                scmRoot.setError(error);
                this.projectScmRootDao.updateProjectScmRoot(scmRoot);
            } else {
                Map map = task.getProjectsBuildDefinitionsMap();
                for (Integer projectId : map.keySet()) {
                    int buildDefinitionId = (Integer)map.get(projectId);
                    Project project = this.projectDao.getProject(projectId.intValue());
                    BuildDefinition buildDef = this.buildDefinitionDao.getBuildDefinition(buildDefinitionId);
                    BuildResult latestBuildResult = this.buildResultDao.getLatestBuildResultForBuildDefinition(projectId.intValue(), buildDefinitionId);
                    if (latestBuildResult != null && (latestBuildResult.getStartTime() < this.startTime || latestBuildResult.getEndTime() <= 0L || latestBuildResult.getEndTime() >= this.endTime) && latestBuildResult.getStartTime() >= this.startTime) continue;
                    BuildResult buildResult = new BuildResult();
                    buildResult.setBuildDefinition(buildDef);
                    buildResult.setError(error);
                    buildResult.setState(4);
                    buildResult.setTrigger(task.getBuildTrigger().getTrigger());
                    buildResult.setUsername(task.getBuildTrigger().getTriggeredBy());
                    buildResult.setStartTime(this.startTime);
                    buildResult.setEndTime(this.endTime);
                    this.buildResultDao.addBuildResult(project, buildResult);
                }
            }
        }
        catch (ContinuumStoreException e) {
            throw new TaskExecutionException("Error while creating result", (Throwable)e);
        }
    }

    private List<Map<String, Object>> getOldScmChanges(int projectId, int buildDefinitionId) throws ContinuumStoreException {
        List<Map<String, Object>> scmChanges = new ArrayList<Map<String, Object>>();
        BuildResult oldBuildResult = this.buildResultDao.getLatestBuildResultForBuildDefinition(projectId, buildDefinitionId);
        if (oldBuildResult != null) {
            ScmResult scmResult = this.getOldScmResults(projectId, oldBuildResult.getBuildNumber(), oldBuildResult.getEndTime());
            scmChanges = this.getScmChanges(scmResult);
        }
        return scmChanges;
    }

    private List<Map<String, Object>> getScmChanges(ScmResult scmResult) {
        ArrayList<Map<String, Object>> scmChanges = new ArrayList<Map<String, Object>>();
        if (scmResult != null && scmResult.getChanges() != null) {
            Iterator i$ = scmResult.getChanges().iterator();
            while (i$.hasNext()) {
                ChangeSet obj;
                ChangeSet changeSet = obj = (ChangeSet)i$.next();
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (StringUtils.isNotEmpty((String)changeSet.getAuthor())) {
                    map.put("changeset-author", changeSet.getAuthor());
                } else {
                    map.put("changeset-author", "");
                }
                if (StringUtils.isNotEmpty((String)changeSet.getComment())) {
                    map.put("changeset-comment", changeSet.getComment());
                } else {
                    map.put("changeset-comment", "");
                }
                if (changeSet.getDateAsDate() != null) {
                    map.put("changeset-date", changeSet.getDateAsDate());
                }
                map.put("changeset-files", this.getScmChangeFiles(changeSet.getFiles()));
                scmChanges.add(map);
            }
        }
        return scmChanges;
    }

    private List<Map<String, String>> getScmChangeFiles(List<ChangeFile> files) {
        ArrayList<Map<String, String>> scmChangeFiles = new ArrayList<Map<String, String>>();
        if (files != null) {
            for (ChangeFile changeFile : files) {
                HashMap<String, String> map = new HashMap<String, String>();
                if (StringUtils.isNotEmpty((String)changeFile.getName())) {
                    map.put("changefile-name", changeFile.getName());
                } else {
                    map.put("changefile-name", "");
                }
                if (StringUtils.isNotEmpty((String)changeFile.getRevision())) {
                    map.put("changefile-revision", changeFile.getRevision());
                } else {
                    map.put("changefile-revision", "");
                }
                if (StringUtils.isNotEmpty((String)changeFile.getStatus())) {
                    map.put("changefile-status", changeFile.getStatus());
                } else {
                    map.put("changefile-status", "");
                }
                scmChangeFiles.add(map);
            }
        }
        return scmChangeFiles;
    }

    private ScmResult getOldScmResults(int projectId, long startId, long fromDate) throws ContinuumStoreException {
        List results = this.buildResultDao.getBuildResultsForProjectFromId(projectId, startId);
        ScmResult res = new ScmResult();
        if (results != null && results.size() > 0) {
            for (BuildResult result : results) {
                List changes;
                ScmResult scmResult = result.getScmResult();
                if (scmResult == null || (changes = scmResult.getChanges()) == null) continue;
                for (ChangeSet changeSet : changes) {
                    if (changeSet.getDate() < fromDate || res.getChanges().contains(changeSet)) continue;
                    res.addChange(changeSet);
                }
            }
        }
        return res;
    }
}

