/*
 * Decompiled with CFR 0.152.
 */
package org.apache.continuum.builder.distributed.taskqueue;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.continuum.builder.distributed.executor.DistributedBuildTaskQueueExecutor;
import org.apache.continuum.builder.distributed.executor.ThreadedDistributedBuildTaskQueueExecutor;
import org.apache.continuum.taskqueue.OverallDistributedBuildQueue;
import org.apache.continuum.taskqueue.PrepareBuildProjectsTask;
import org.codehaus.plexus.taskqueue.Task;
import org.codehaus.plexus.taskqueue.TaskQueue;
import org.codehaus.plexus.taskqueue.TaskQueueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOverallDistributedBuildQueue
implements OverallDistributedBuildQueue {
    private String buildAgentUrl;
    private DistributedBuildTaskQueueExecutor distributedBuildTaskQueueExecutor;

    public void addToDistributedBuildQueue(Task distributedBuildTask) throws TaskQueueException {
        this.getDistributedBuildQueue().put(distributedBuildTask);
    }

    public String getBuildAgentUrl() {
        return this.buildAgentUrl;
    }

    public TaskQueue getDistributedBuildQueue() {
        return ((ThreadedDistributedBuildTaskQueueExecutor)this.distributedBuildTaskQueueExecutor).getQueue();
    }

    public DistributedBuildTaskQueueExecutor getDistributedBuildTaskQueueExecutor() {
        return this.distributedBuildTaskQueueExecutor;
    }

    public List<PrepareBuildProjectsTask> getProjectsInQueue() throws TaskQueueException {
        return this.getDistributedBuildQueue().getQueueSnapshot();
    }

    public boolean isInDistributedBuildQueue(int projectGroupId, int scmRootId) throws TaskQueueException {
        List<PrepareBuildProjectsTask> tasks = this.getProjectsInQueue();
        for (PrepareBuildProjectsTask task : tasks) {
            if (task == null || task.getProjectGroupId() != projectGroupId || task.getProjectScmRootId() != scmRootId) continue;
            return true;
        }
        return false;
    }

    public void removeFromDistributedBuildQueue(int projectGroupId, int scmRootId) throws TaskQueueException {
        List<PrepareBuildProjectsTask> tasks = this.getProjectsInQueue();
        for (PrepareBuildProjectsTask task : tasks) {
            if (task == null || task.getProjectGroupId() != projectGroupId || task.getProjectScmRootId() != scmRootId) continue;
            this.getDistributedBuildQueue().remove((Task)task);
            return;
        }
    }

    public void removeFromDistributedBuildQueue(int[] hashCodes) throws TaskQueueException {
        List<PrepareBuildProjectsTask> tasks = this.getProjectsInQueue();
        ArrayList<PrepareBuildProjectsTask> tasksToRemove = new ArrayList<PrepareBuildProjectsTask>();
        for (PrepareBuildProjectsTask task : tasks) {
            if (task == null || !ArrayUtils.contains((int[])hashCodes, (int)task.getHashCode())) continue;
            tasksToRemove.add(task);
        }
        if (!tasksToRemove.isEmpty()) {
            this.getDistributedBuildQueue().removeAll(tasksToRemove);
        }
    }

    public void removeFromDistributedBuildQueueByHashCode(int hashCode) throws TaskQueueException {
        List<PrepareBuildProjectsTask> tasks = this.getProjectsInQueue();
        for (PrepareBuildProjectsTask task : tasks) {
            if (task == null || task.getHashCode() != hashCode) continue;
            this.getDistributedBuildQueue().remove((Task)task);
            return;
        }
    }

    public void setBuildAgentUrl(String buildAgentUrl) {
        this.buildAgentUrl = buildAgentUrl;
    }

    public void setDistributedBuildTaskQueueExecutor(DistributedBuildTaskQueueExecutor distributedBuildTaskQueueExecutor) {
        this.distributedBuildTaskQueueExecutor = distributedBuildTaskQueueExecutor;
    }
}

