/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.ws.rs.Path;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.jaxrs.JAXRSInvoker;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.JAXRSUtils;
import org.apache.cxf.jaxrs.lifecycle.PerRequestResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.MethodDispatcher;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.AbstractServiceFactoryBean;
import org.apache.cxf.service.invoker.Invoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSServiceFactoryBean
extends AbstractServiceFactoryBean {
    protected List<ClassResourceInfo> classResourceInfos = new ArrayList<ClassResourceInfo>();
    protected Map<Class, ResourceProvider> resourceProviders = new HashMap<Class, ResourceProvider>();
    private Invoker invoker;
    private Executor executor;
    private Map<String, Object> properties;

    public Service create() {
        this.initializeServiceModel();
        this.initializeDefaultInterceptors();
        if (this.invoker != null) {
            this.getService().setInvoker(this.getInvoker());
        } else {
            this.getService().setInvoker(this.createInvoker());
        }
        if (this.getExecutor() != null) {
            this.getService().setExecutor(this.getExecutor());
        }
        if (this.getDataBinding() != null) {
            this.getService().setDataBinding(this.getDataBinding());
        }
        return this.getService();
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Invoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public List<Class> getResourceClasses() {
        ArrayList<Class> resourceClasses = new ArrayList<Class>();
        for (ClassResourceInfo cri : this.classResourceInfos) {
            resourceClasses.add(cri.getResourceClass());
        }
        return resourceClasses;
    }

    public void setResourceClasses(List<Class> classes) {
        for (Class resourceClass : classes) {
            ClassResourceInfo classResourceInfo = this.createClassResourceInfo(resourceClass, resourceClass, true);
            this.classResourceInfos.add(classResourceInfo);
        }
    }

    public void setResourceClasses(Class ... classes) {
        this.setResourceClasses(Arrays.asList(classes));
    }

    public void setResourceClassesFromBeans(List<Object> beans) {
        for (Object bean : beans) {
            ClassResourceInfo classResourceInfo = this.createClassResourceInfo(bean.getClass(), ClassHelper.getRealClass((Object)bean), true);
            this.classResourceInfos.add(classResourceInfo);
        }
    }

    public void setResourceProvider(Class c, ResourceProvider rp) {
        this.resourceProviders.put(c, rp);
        this.updateClassResourceProviders();
    }

    protected void initializeServiceModel() {
        this.updateClassResourceProviders();
        JAXRSServiceImpl service = new JAXRSServiceImpl(this.classResourceInfos);
        this.setService(service);
        if (this.properties != null) {
            service.putAll(this.properties);
        }
    }

    private void updateClassResourceProviders() {
        for (ClassResourceInfo cri : this.classResourceInfos) {
            ResourceProvider rp = this.resourceProviders.get(cri.getResourceClass());
            if (rp != null) {
                cri.setResourceProvider(rp);
                continue;
            }
            rp = new PerRequestResourceProvider(cri.getResourceClass());
            cri.setResourceProvider(rp);
        }
    }

    protected ClassResourceInfo createClassResourceInfo(Class<?> rClass, Class<?> sClass, boolean root) {
        ClassResourceInfo cri = new ClassResourceInfo(rClass, sClass, root);
        if (root) {
            URITemplate t = URITemplate.createTemplate(cri, cri.getPath());
            cri.setURITemplate(t);
        }
        MethodDispatcher md = this.createOperation(cri);
        cri.setMethodDispatcher(md);
        return cri;
    }

    protected MethodDispatcher createOperation(ClassResourceInfo cri) {
        MethodDispatcher md = new MethodDispatcher();
        for (Method m : cri.getServiceClass().getMethods()) {
            URITemplate t;
            OperationResourceInfo ori;
            String httpMethod = JAXRSUtils.getHttpMethodValue(m);
            Path path = (Path)JAXRSUtils.getMethodAnnotation(m, Path.class);
            if (httpMethod != null && path != null) {
                ori = new OperationResourceInfo(m, cri);
                t = URITemplate.createTemplate(cri, path);
                ori.setURITemplate(t);
                ori.setHttpMethod(httpMethod);
                md.bind(ori, m);
                continue;
            }
            if (path != null) {
                ori = new OperationResourceInfo(m, cri);
                t = URITemplate.createTemplate(cri, path);
                ori.setURITemplate(t);
                md.bind(ori, m);
                Class<?> subResourceClass = m.getReturnType();
                ClassResourceInfo subCri = this.createClassResourceInfo(subResourceClass, subResourceClass, false);
                cri.addSubClassResourceInfo(subCri);
                continue;
            }
            if (httpMethod == null) continue;
            ori = new OperationResourceInfo(m, cri);
            t = URITemplate.createTemplate(cri, null);
            ori.setURITemplate(t);
            ori.setHttpMethod(httpMethod);
            md.bind(ori, m);
        }
        return md;
    }

    protected Invoker createInvoker() {
        return new JAXRSInvoker();
    }
}

