/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.ProduceMime;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.cxf.jaxrs.JAXRSUtils;
import org.apache.cxf.jaxrs.provider.AcceptTypeQueryHandler;
import org.apache.cxf.jaxrs.provider.AtomEntryProvider;
import org.apache.cxf.jaxrs.provider.AtomFeedProvider;
import org.apache.cxf.jaxrs.provider.BinaryDataProvider;
import org.apache.cxf.jaxrs.provider.FormEncodingReaderProvider;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.jaxrs.provider.JSONProvider;
import org.apache.cxf.jaxrs.provider.SourceProvider;
import org.apache.cxf.jaxrs.provider.StringProvider;
import org.apache.cxf.jaxrs.provider.SystemQueryHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProviderFactory {
    private static final ProviderFactory PF = new ProviderFactory();
    private List<MessageBodyReader> defaultMessageReaders = new ArrayList<MessageBodyReader>();
    private List<MessageBodyWriter> defaultMessageWriters = new ArrayList<MessageBodyWriter>();
    private List<MessageBodyReader> userMessageReaders = new ArrayList<MessageBodyReader>();
    private List<MessageBodyWriter> userMessageWriters = new ArrayList<MessageBodyWriter>();
    private List<SystemQueryHandler> queryHandlers = new ArrayList<SystemQueryHandler>();

    private ProviderFactory() {
        this.setProviders(this.defaultMessageReaders, this.defaultMessageWriters, new JSONProvider(), new BinaryDataProvider(), new JAXBElementProvider(), new StringProvider(), new SourceProvider(), new AtomFeedProvider(), new AtomEntryProvider(), new FormEncodingReaderProvider());
        this.queryHandlers.add(new AcceptTypeQueryHandler());
    }

    public static ProviderFactory getInstance() {
        return PF;
    }

    public <T> MessageBodyReader<T> createMessageBodyReader(Class<T> bodyType, MediaType mediaType) {
        MessageBodyReader<T> mr = this.chooseMessageReader(this.userMessageReaders, bodyType, mediaType);
        if (mr == null) {
            mr = this.chooseMessageReader(this.defaultMessageReaders, bodyType, mediaType);
        }
        return mr;
    }

    public SystemQueryHandler getQueryHandler(MultivaluedMap<String, String> query) {
        for (SystemQueryHandler h : this.queryHandlers) {
            if (!h.supports(query)) continue;
            return h;
        }
        return null;
    }

    public <T> MessageBodyWriter<T> createMessageBodyWriter(Class<T> bodyType, MediaType mediaType) {
        MessageBodyWriter<T> mw = this.chooseMessageWriter(this.userMessageWriters, bodyType, mediaType);
        if (mw == null) {
            mw = this.chooseMessageWriter(this.defaultMessageWriters, bodyType, mediaType);
        }
        return mw;
    }

    private void setProviders(List<MessageBodyReader> readers, List<MessageBodyWriter> writers, Object ... providers) {
        for (Object o : providers) {
            if (MessageBodyReader.class.isAssignableFrom(o.getClass())) {
                readers.add((MessageBodyReader)o);
            }
            if (!MessageBodyWriter.class.isAssignableFrom(o.getClass())) continue;
            writers.add((MessageBodyWriter)o);
        }
        this.sortReaders(readers);
        this.sortWriters(writers);
    }

    private void sortReaders(List<MessageBodyReader> entityProviders) {
        Collections.sort(entityProviders, new MessageBodyReaderComparator());
    }

    private void sortWriters(List<MessageBodyWriter> entityProviders) {
        Collections.sort(entityProviders, new MessageBodyWriterComparator());
    }

    private <T> MessageBodyReader<T> chooseMessageReader(List<MessageBodyReader> readers, Class<T> type, MediaType mediaType) {
        for (MessageBodyReader ep : readers) {
            if (!ep.isReadable(type)) continue;
            List<MediaType> supportedMediaTypes = JAXRSUtils.getConsumeTypes(ep.getClass().getAnnotation(ConsumeMime.class));
            List<MediaType> availableMimeTypes = JAXRSUtils.intersectMimeTypes(Collections.singletonList(mediaType), supportedMediaTypes);
            if (availableMimeTypes.size() == 0) continue;
            return ep;
        }
        return null;
    }

    private <T> MessageBodyWriter<T> chooseMessageWriter(List<MessageBodyWriter> writers, Class<T> type, MediaType mediaType) {
        for (MessageBodyWriter ep : writers) {
            if (!ep.isWriteable(type)) continue;
            List<MediaType> supportedMediaTypes = JAXRSUtils.getProduceTypes(ep.getClass().getAnnotation(ProduceMime.class));
            List<MediaType> availableMimeTypes = JAXRSUtils.intersectMimeTypes(Collections.singletonList(mediaType), supportedMediaTypes);
            if (availableMimeTypes.size() == 0) continue;
            return ep;
        }
        return null;
    }

    public boolean registerUserEntityProvider(Object o) {
        this.setProviders(this.userMessageReaders, this.userMessageWriters, o);
        return true;
    }

    public boolean deregisterUserEntityProvider(Object o) {
        boolean result = false;
        if (o instanceof MessageBodyReader) {
            result = this.userMessageReaders.remove(o);
        }
        return o instanceof MessageBodyReader ? result && this.userMessageWriters.remove(o) : result;
    }

    public List<MessageBodyReader> getDefaultMessageReaders() {
        return this.defaultMessageReaders;
    }

    public List<MessageBodyWriter> getDefaultMessageWriters() {
        return this.defaultMessageWriters;
    }

    public List<MessageBodyReader> getUserMessageReaders() {
        return this.userMessageReaders;
    }

    public List<MessageBodyWriter> getUserMessageWriters() {
        return this.userMessageWriters;
    }

    public void clearUserMessageProviders() {
        this.userMessageReaders.clear();
        this.userMessageWriters.clear();
    }

    public void setUserEntityProviders(List<?> userProviders) {
        this.setProviders(this.userMessageReaders, this.userMessageWriters, userProviders.toArray());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageBodyWriterComparator
    implements Comparator<MessageBodyWriter> {
        private MessageBodyWriterComparator() {
        }

        @Override
        public int compare(MessageBodyWriter e1, MessageBodyWriter e2) {
            ProduceMime c = e1.getClass().getAnnotation(ProduceMime.class);
            String[] mimeType1 = new String[]{"*/*"};
            if (c != null) {
                mimeType1 = c.value();
            }
            ProduceMime c2 = e2.getClass().getAnnotation(ProduceMime.class);
            String[] mimeType2 = new String[]{"*/*"};
            if (c2 != null) {
                mimeType2 = c2.value();
            }
            return this.compareString(mimeType1[0], mimeType2[0]);
        }

        private int compareString(String str1, String str2) {
            if (!str1.startsWith("*/") && str2.startsWith("*/")) {
                return -1;
            }
            if (str1.startsWith("*/") && !str2.startsWith("*/")) {
                return 1;
            }
            return str1.compareTo(str2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageBodyReaderComparator
    implements Comparator<MessageBodyReader> {
        private MessageBodyReaderComparator() {
        }

        @Override
        public int compare(MessageBodyReader e1, MessageBodyReader e2) {
            ConsumeMime c = e1.getClass().getAnnotation(ConsumeMime.class);
            String[] mimeType1 = new String[]{"*/*"};
            if (c != null) {
                mimeType1 = c.value();
            }
            ConsumeMime c2 = e2.getClass().getAnnotation(ConsumeMime.class);
            String[] mimeType2 = new String[]{"*/*"};
            if (c2 != null) {
                mimeType2 = c2.value();
            }
            return this.compareString(mimeType1[0], mimeType2[0]);
        }

        private int compareString(String str1, String str2) {
            if (!str1.startsWith("*/") && str2.startsWith("*/")) {
                return -1;
            }
            if (str1.startsWith("*/") && !str2.startsWith("*/")) {
                return 1;
            }
            return str1.compareTo(str2);
        }
    }
}

