/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.utils.HttpUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FormUtils {
    private static final String FORM_DATA_TYPE = "form-data";

    private FormUtils() {
    }

    public static String readBody(InputStream is) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)bos, (int)1024);
            return new String(bos.toByteArray(), "UTF-8");
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    public static void populateMapFromString(MultivaluedMap<String, String> params, String postBody, boolean decode) {
        if (!StringUtils.isEmpty((String)postBody)) {
            List<String> parts = Arrays.asList(postBody.split("&"));
            for (String part : parts) {
                String[] keyValue = part.split("=");
                if (keyValue.length == 2) {
                    if (decode) {
                        params.add((Object)keyValue[0], (Object)HttpUtils.urlDecode(keyValue[1]));
                        continue;
                    }
                    params.add((Object)keyValue[0], (Object)keyValue[1]);
                    continue;
                }
                params.add((Object)keyValue[0], (Object)"");
            }
        }
    }

    public static void populateMapFromMultipart(MultivaluedMap<String, String> params, MultipartBody body, boolean decode) {
        List<Attachment> atts = body.getAllAttachments();
        for (Attachment a : atts) {
            ContentDisposition cd = a.getContentDisposition();
            if (cd == null || !FORM_DATA_TYPE.equalsIgnoreCase(cd.getType()) || cd.getParameter("name") == null) {
                throw new WebApplicationException(415);
            }
            String name = cd.getParameter("name").replace("\"", "").replace("'", "");
            try {
                String value = IOUtils.toString((InputStream)a.getDataHandler().getInputStream());
                params.add((Object)name, (Object)(decode ? HttpUtils.urlDecode(value) : value));
            }
            catch (IOException ex) {
                throw new WebApplicationException(415);
            }
        }
    }
}

