/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import java.lang.reflect.Method;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.Path;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.MethodDispatcher;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(ResourceUtils.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(ResourceUtils.class);

    private ResourceUtils() {
    }

    public static ClassResourceInfo createClassResourceInfo(Class<?> rClass, Class<?> sClass, boolean root, boolean enableStatic) {
        ClassResourceInfo cri = new ClassResourceInfo(rClass, sClass, root, enableStatic);
        if (root) {
            URITemplate t = URITemplate.createTemplate(cri, cri.getPath());
            cri.setURITemplate(t);
        }
        ResourceUtils.evaluateResourceClass(cri, enableStatic);
        return ResourceUtils.checkMethodDispatcher(cri) ? cri : null;
    }

    private static void evaluateResourceClass(ClassResourceInfo cri, boolean enableStatic) {
        MethodDispatcher md = new MethodDispatcher();
        for (Method m : cri.getServiceClass().getMethods()) {
            Method annotatedMethod = AnnotationUtils.getAnnotatedMethod(m);
            String httpMethod = AnnotationUtils.getHttpMethodValue(annotatedMethod);
            Path path = (Path)AnnotationUtils.getMethodAnnotation(annotatedMethod, Path.class);
            if (httpMethod == null && path == null) continue;
            md.bind(ResourceUtils.createOperationInfo(m, annotatedMethod, cri, path, httpMethod), m);
            if (httpMethod != null) continue;
            Class<?> subClass = m.getReturnType();
            if (!enableStatic) continue;
            ClassResourceInfo subCri = cri.findResource(subClass, subClass);
            if (subCri == null) {
                ClassResourceInfo classResourceInfo = subCri = subClass == cri.getServiceClass() ? cri : ResourceUtils.createClassResourceInfo(subClass, subClass, false, enableStatic);
            }
            if (subCri == null) continue;
            cri.addSubClassResourceInfo(subCri);
        }
        cri.setMethodDispatcher(md);
    }

    private static OperationResourceInfo createOperationInfo(Method m, Method annotatedMethod, ClassResourceInfo cri, Path path, String httpMethod) {
        OperationResourceInfo ori = new OperationResourceInfo(m, cri);
        URITemplate t = URITemplate.createTemplate(cri, path);
        ori.setURITemplate(t);
        ori.setHttpMethod(httpMethod);
        ori.setAnnotatedMethod(annotatedMethod);
        return ori;
    }

    private static boolean checkMethodDispatcher(ClassResourceInfo cr) {
        if (cr.getMethodDispatcher().getOperationResourceInfos().isEmpty()) {
            LOG.warning(new Message("NO_RESOURCE_OP_EXC", BUNDLE, new Object[]{cr.getServiceClass().getName()}).toString());
            return false;
        }
        return true;
    }
}

