/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.JAXRSUtils;
import org.apache.cxf.jaxrs.MetadataMap;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.invoker.AbstractInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSInvoker
extends AbstractInvoker {
    private List<Object> resourceObjects;

    public JAXRSInvoker() {
    }

    public JAXRSInvoker(List<Object> resourceObjects) {
        this.resourceObjects = resourceObjects;
    }

    public Object invoke(Exchange exchange, Object request) {
        return this.invoke(exchange, request, this.resourceObjects);
    }

    public Object invoke(Exchange exchange, Object request, List<Object> resources) {
        OperationResourceInfo ori = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
        ClassResourceInfo cri = ori.getClassResourceInfo();
        Method methodToInvoke = cri.getMethodDispatcher().getMethod(ori);
        Object resourceObject = this.getServiceObject(exchange, resources);
        if (Proxy.class.isInstance(resourceObject)) {
            for (Class<?> c : resourceObject.getClass().getInterfaces()) {
                try {
                    Method m = c.getMethod(methodToInvoke.getName(), methodToInvoke.getParameterTypes());
                    if (m == null) continue;
                    methodToInvoke = m;
                    break;
                }
                catch (NoSuchMethodException ex) {
                    // empty catch block
                }
            }
        }
        if (cri.isRoot()) {
            JAXRSUtils.injectHttpContextValues(resourceObject, ori, exchange.getInMessage());
            JAXRSUtils.injectServletResourceValues(resourceObject, ori, exchange.getInMessage());
        }
        List params = null;
        if (request instanceof List) {
            params = CastUtils.cast((List)((List)request));
        } else if (request != null) {
            params = new MessageContentsList(new Object[]{request});
        }
        Object result = null;
        try {
            result = this.invoke(exchange, resourceObject, methodToInvoke, params);
        }
        catch (Fault ex) {
            if (ex.getCause() instanceof WebApplicationException) {
                WebApplicationException wex = (WebApplicationException)ex.getCause();
                result = wex.getResponse() != null ? wex.getResponse() : Response.serverError().build();
                return new MessageContentsList(new Object[]{result});
            }
            throw ex;
        }
        if (ori.isSubResourceLocator()) {
            String acceptContentType;
            if (result != null) {
                if (result instanceof MessageContentsList) {
                    result = ((MessageContentsList)result).get(0);
                } else if (result instanceof List) {
                    result = ((List)result).get(0);
                } else if (result.getClass().isArray()) {
                    result = ((Object[])result)[0];
                }
            }
            ArrayList<Object> newResourceObjects = new ArrayList<Object>();
            newResourceObjects.add(result);
            Message msg = exchange.getInMessage();
            MetadataMap<String, String> values = new MetadataMap<String, String>();
            String subResourcePath = (String)msg.get((Object)"relative.path");
            String httpMethod = (String)msg.get((Object)Message.HTTP_REQUEST_METHOD);
            String contentType = (String)msg.get((Object)"Content-Type");
            if (contentType == null) {
                contentType = "*/*";
            }
            if ((acceptContentType = (String)msg.get((Object)"Accept")) == null) {
                acceptContentType = "*/*";
            }
            ClassResourceInfo subCri = JAXRSUtils.findSubResourceClass(cri, result.getClass());
            OperationResourceInfo subOri = JAXRSUtils.findTargetMethod(subCri, subResourcePath, httpMethod, values, contentType, acceptContentType);
            exchange.put(OperationResourceInfo.class, (Object)subOri);
            msg.put((Object)"relative.path", values.getFirst("FINAL_MATCH_GROUP"));
            msg.put((Object)"jaxrs.template.parameters", values);
            List<Object> newParams = JAXRSUtils.processParameters(subOri, values, msg);
            msg.setContent(List.class, newParams);
            return this.invoke(exchange, newParams, newResourceObjects);
        }
        return result;
    }

    public Object getServiceObject(Exchange exchange) {
        return this.getServiceObject(exchange, this.resourceObjects);
    }

    public Object getServiceObject(Exchange exchange, List<Object> resources) {
        Object serviceObject = null;
        OperationResourceInfo ori = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
        ClassResourceInfo cri = ori.getClassResourceInfo();
        if (resources != null) {
            Class<?> c = cri.getResourceClass();
            for (Object resourceObject : resources) {
                if (!c.isInstance(resourceObject)) continue;
                serviceObject = resourceObject;
            }
        }
        if (serviceObject == null) {
            serviceObject = cri.getResourceProvider().getInstance();
        }
        return serviceObject;
    }
}

