/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.BindingConfiguration;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.AbstractEndpointFactory;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.model.UserResource;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractJAXRSFactoryBean
extends AbstractEndpointFactory {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractJAXRSFactoryBean.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(AbstractJAXRSFactoryBean.class);
    protected List<String> schemaLocations;
    protected JAXRSServiceFactoryBean serviceFactory;
    protected List<?> entityProviders;

    protected AbstractJAXRSFactoryBean() {
        this(new JAXRSServiceFactoryBean());
    }

    protected AbstractJAXRSFactoryBean(JAXRSServiceFactoryBean serviceFactory) {
        this.serviceFactory = serviceFactory;
        this.setBindingId("http://apache.org/cxf/binding/jaxrs");
    }

    protected EndpointInfo createEndpointInfo() throws BusException {
        String transportId = this.getTransportId();
        if (transportId == null && this.getAddress() != null) {
            DestinationFactory df = this.getDestinationFactory();
            if (df == null) {
                DestinationFactoryManager dfm = (DestinationFactoryManager)this.getBus().getExtension(DestinationFactoryManager.class);
                df = dfm.getDestinationFactoryForUri(this.getAddress());
            }
            if (df != null) {
                transportId = (String)df.getTransportIds().get(0);
            }
        }
        if (transportId == null) {
            transportId = "http://schemas.xmlsoap.org/wsdl/soap/http";
        }
        this.setTransportId(transportId);
        EndpointInfo ei = new EndpointInfo();
        ei.setTransportId(transportId);
        ei.setName(this.serviceFactory.getService().getName());
        ei.setAddress(this.getAddress());
        BindingInfo bindingInfo = this.createBindingInfo();
        ei.setBinding(bindingInfo);
        return ei;
    }

    protected BindingInfo createBindingInfo() {
        BindingFactoryManager mgr = (BindingFactoryManager)this.getBus().getExtension(BindingFactoryManager.class);
        String binding = this.getBindingId();
        BindingConfiguration bindingConfig = this.getBindingConfig();
        if (binding == null && bindingConfig != null) {
            binding = bindingConfig.getBindingId();
        }
        if (binding == null) {
            binding = "http://apache.org/cxf/binding/jaxrs";
        }
        try {
            BindingFactory bindingFactory = mgr.getBindingFactory(binding);
            this.setBindingFactory(bindingFactory);
            return bindingFactory.createBindingInfo(this.serviceFactory.getService(), binding, (Object)bindingConfig);
        }
        catch (BusException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public JAXRSServiceFactoryBean getServiceFactory() {
        return this.serviceFactory;
    }

    public void setServiceFactory(JAXRSServiceFactoryBean serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    protected Endpoint createEndpoint() throws BusException, EndpointException {
        Service service = this.serviceFactory.getService();
        if (service == null) {
            service = this.serviceFactory.create();
        }
        EndpointInfo ei = this.createEndpointInfo();
        EndpointImpl ep = new EndpointImpl(this.getBus(), this.getServiceFactory().getService(), ei);
        if (this.properties != null) {
            ep.putAll(this.properties);
        }
        if (this.getInInterceptors() != null) {
            ep.getInInterceptors().addAll(this.getInInterceptors());
        }
        if (this.getOutInterceptors() != null) {
            ep.getOutInterceptors().addAll(this.getOutInterceptors());
        }
        if (this.getInFaultInterceptors() != null) {
            ep.getInFaultInterceptors().addAll(this.getInFaultInterceptors());
        }
        if (this.getOutFaultInterceptors() != null) {
            ep.getOutFaultInterceptors().addAll(this.getOutFaultInterceptors());
        }
        return ep;
    }

    public void setSchemaLocation(String schema) {
        this.setSchemaLocations(Collections.singletonList(schema));
    }

    public void setSchemaLocations(List<String> schemas) {
        this.schemaLocations = schemas;
    }

    public List<?> getProviders() {
        return this.entityProviders;
    }

    public void setProviders(List<? extends Object> providers) {
        this.entityProviders = providers;
    }

    public void setProvider(Object provider) {
        this.setProviders(Collections.singletonList(provider));
    }

    protected void checkResources() {
        if (!this.serviceFactory.resourcesAvailable()) {
            Message msg = new Message("NO_RESOURCES_AVAILABLE", BUNDLE, new Object[0]);
            LOG.severe(msg.toString());
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    protected ProviderFactory setupFactory(Endpoint ep) {
        ProviderFactory factory = ProviderFactory.getInstance();
        if (this.entityProviders != null) {
            factory.setUserProviders(this.entityProviders);
        }
        if (this.schemaLocations != null) {
            factory.setSchemaLocations(this.schemaLocations);
        }
        ep.put((Object)ProviderFactory.class.getName(), (Object)factory);
        return factory;
    }

    public void setModelBeans(UserResource ... resources) {
        this.setModelBeans(Arrays.asList(resources));
    }

    public void setModelBeans(List<UserResource> resources) {
        this.serviceFactory.setUserResources(resources);
    }

    public void setModelRef(String modelRef) {
        List<UserResource> resources = ResourceUtils.getUserResources(modelRef);
        if (resources != null) {
            this.serviceFactory.setUserResources(resources);
        }
    }
}

