/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import java.util.ArrayList;
import java.util.List;

final class CurlyBraceTokenizer {
    private List<String> tokens = new ArrayList<String>();
    private int tokenIdx;

    public CurlyBraceTokenizer(String string) {
        int idx;
        boolean outside = true;
        int level = 0;
        int lastIdx = 0;
        for (idx = 0; idx < string.length(); ++idx) {
            if (string.charAt(idx) == '{') {
                if (outside) {
                    if (lastIdx < idx) {
                        this.tokens.add(string.substring(lastIdx, idx));
                    }
                    lastIdx = idx;
                    outside = false;
                    continue;
                }
                ++level;
                continue;
            }
            if (string.charAt(idx) != '}' || outside) continue;
            if (level > 0) {
                --level;
                continue;
            }
            if (lastIdx < idx) {
                this.tokens.add(string.substring(lastIdx, idx + 1));
            }
            lastIdx = idx + 1;
            outside = true;
        }
        if (lastIdx < idx) {
            this.tokens.add(string.substring(lastIdx, idx));
        }
    }

    public static boolean insideBraces(String token) {
        return token.charAt(0) == '{' && token.charAt(token.length() - 1) == '}';
    }

    public static String stripBraces(String token) {
        if (CurlyBraceTokenizer.insideBraces(token)) {
            return token.substring(1, token.length() - 1);
        }
        return token;
    }

    public boolean hasNext() {
        return this.tokens.size() > this.tokenIdx;
    }

    public String next() {
        if (this.hasNext()) {
            return this.tokens.get(this.tokenIdx++);
        }
        throw new IllegalStateException("no more elements");
    }
}

