/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.impl.MetadataMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerWebApplicationException
extends WebApplicationException {
    private String errorMessage;

    public ServerWebApplicationException() {
    }

    public ServerWebApplicationException(Response response) {
        super(response);
    }

    public ServerWebApplicationException(Throwable cause, Response response) {
        super(cause, response);
    }

    public int getStatus() {
        return this.getResponse().getStatus();
    }

    public MultivaluedMap<String, String> getHeaders() {
        MultivaluedMap metadata = this.getResponse().getMetadata();
        MetadataMap<String, String> headers = new MetadataMap<String, String>(metadata.size());
        for (String key : metadata.keySet()) {
            for (Object strObject : (List)metadata.get((Object)key)) {
                headers.add(key, strObject.toString());
            }
        }
        return headers;
    }

    public String getMessage() {
        if (this.errorMessage == null) {
            this.errorMessage = this.readErrorMessage();
        }
        return this.errorMessage;
    }

    private String readErrorMessage() {
        Object entity = this.getResponse().getEntity();
        try {
            return entity == null ? "" : (entity instanceof InputStream ? IOUtils.readStringFromStream((InputStream)((InputStream)entity)) : entity.toString());
        }
        catch (IOException ex) {
            return "";
        }
    }

    public String toString() {
        String lineSep = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("Status : " + this.getStatus()).append(lineSep);
        sb.append("Headers : ").append(lineSep);
        MultivaluedMap<String, String> headers = this.getHeaders();
        for (String header : headers.keySet()) {
            sb.append(header + " :");
            Iterator it = ((List)headers.get((Object)header)).iterator();
            while (it.hasNext()) {
                sb.append(' ').append((String)it.next());
                if (!it.hasNext()) continue;
                sb.append(',');
            }
            sb.append(lineSep);
        }
        String message = this.getMessage();
        if (!StringUtils.isEmpty((String)message)) {
            sb.append("Error message : ").append(lineSep);
            sb.append(message).append(lineSep);
        }
        return sb.toString();
    }
}

