/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model.wadl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.ReflectionInvokationHandler;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.XmlSchemaPrimitiveUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxb.JAXBBeanInfo;
import org.apache.cxf.jaxb.JAXBContextProxy;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.ext.Description;
import org.apache.cxf.jaxrs.ext.Oneway;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.ext.xml.XMLName;
import org.apache.cxf.jaxrs.ext.xml.XMLSource;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.model.wadl.ElementQNameResolver;
import org.apache.cxf.jaxrs.model.wadl.WadlElement;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.jaxrs.utils.schemas.SchemaHandler;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.Service;
import org.apache.cxf.staxutils.DelegatingXMLStreamWriter;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.ws.commons.schema.XmlSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WadlGenerator
implements RequestHandler {
    public static final String WADL_QUERY = "_wadl";
    public static final MediaType WADL_TYPE = MediaType.valueOf((String)"application/vnd.sun.wadl+xml");
    public static final String WADL_NS = "http://wadl.dev.java.net/2009/02";
    private static final Logger LOG = LogUtils.getL7dLogger(WadlGenerator.class);
    private static final String JAXB_DEFAULT_NAMESPACE = "##default";
    private static final String JAXB_DEFAULT_NAME = "##default";
    private static final String CLASSPATH_PREFIX = "classpath:";
    private String wadlNamespace;
    private boolean ignoreMessageWriters = true;
    private boolean singleResourceMultipleMethods = true;
    private boolean useSingleSlashResource;
    private boolean addResourceAndMethodIds;
    private boolean useJaxbContextForQnames = true;
    private List<String> externalSchemasCache;
    private List<URI> externalSchemaLinks;
    private Map<String, List<String>> externalQnamesMap;
    private ElementQNameResolver resolver;
    private List<String> privateAddresses;

    public WadlGenerator() {
    }

    public WadlGenerator(WadlGenerator other) {
        this.wadlNamespace = other.wadlNamespace;
        this.externalQnamesMap = other.externalQnamesMap;
        this.externalSchemaLinks = other.externalSchemaLinks;
        this.externalSchemasCache = other.externalSchemasCache;
        this.ignoreMessageWriters = other.ignoreMessageWriters;
        this.privateAddresses = other.privateAddresses;
        this.resolver = other.resolver;
        this.addResourceAndMethodIds = other.addResourceAndMethodIds;
        this.singleResourceMultipleMethods = other.singleResourceMultipleMethods;
        this.useJaxbContextForQnames = other.useJaxbContextForQnames;
        this.useSingleSlashResource = other.useSingleSlashResource;
    }

    @Override
    public Response handleRequest(Message m, ClassResourceInfo resource) {
        if (!"GET".equals(m.get((Object)"org.apache.cxf.request.method"))) {
            return null;
        }
        UriInfoImpl ui = new UriInfoImpl(m);
        if (!ui.getQueryParameters().containsKey((Object)WADL_QUERY)) {
            return null;
        }
        if (this.isPrivate(m)) {
            return Response.status((int)401).build();
        }
        StringBuilder sbMain = new StringBuilder();
        sbMain.append("<application xmlns=\"").append(this.getNamespace()).append("\" xmlns:xs=\"").append("http://www.w3.org/2001/XMLSchema").append("\"");
        StringBuilder sbGrammars = new StringBuilder();
        sbGrammars.append("<grammars>");
        StringBuilder sbResources = new StringBuilder();
        sbResources.append("<resources base=\"").append(ui.getBaseUri().toString()).append("\">");
        List<ClassResourceInfo> cris = this.getResourcesList(m, resource);
        Set<Class<?>> allTypes = ResourceUtils.getAllRequestResponseTypes(cris, this.useJaxbContextForQnames).keySet();
        JAXBContext context = this.useJaxbContextForQnames ? ResourceUtils.createJaxbContext(new HashSet(allTypes), null, null) : null;
        SchemaWriter schemaWriter = this.createSchemaWriter(context, ui);
        ElementQNameResolver qnameResolver = schemaWriter == null ? null : this.createElementQNameResolver(context);
        IdentityHashMap clsMap = new IdentityHashMap();
        HashSet<ClassResourceInfo> visitedResources = new HashSet<ClassResourceInfo>();
        for (ClassResourceInfo cri : cris) {
            this.startResourceTag(sbResources, cri.getServiceClass(), cri.getURITemplate().getValue());
            this.handleDocs(cri.getServiceClass().getAnnotations(), sbResources);
            this.handleResource(sbResources, allTypes, qnameResolver, clsMap, cri, visitedResources);
            sbResources.append("</resource>");
        }
        sbResources.append("</resources>");
        this.handleGrammars(sbMain, sbGrammars, schemaWriter, clsMap);
        sbGrammars.append("</grammars>");
        sbMain.append(">");
        sbMain.append(sbGrammars.toString());
        sbMain.append(sbResources.toString());
        sbMain.append("</application>");
        m.getExchange().put((Object)"ignore.message.writers", (Object)this.ignoreMessageWriters);
        HttpHeadersImpl headers = new HttpHeadersImpl(m);
        MediaType type = headers.getAcceptableMediaTypes().contains(MediaType.APPLICATION_XML_TYPE) ? MediaType.APPLICATION_XML_TYPE : WADL_TYPE;
        return Response.ok().type(type).entity((Object)sbMain.toString()).build();
    }

    private void handleGrammars(StringBuilder sbApp, StringBuilder sbGrammars, SchemaWriter writer, Map<Class<?>, QName> clsMap) {
        if (writer == null) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (QName qName : clsMap.values()) {
            map.put(qName.getPrefix(), qName.getNamespaceURI());
        }
        for (Map.Entry entry : map.entrySet()) {
            sbApp.append(" xmlns:").append((String)entry.getKey()).append("=\"").append((String)entry.getValue()).append("\"");
        }
        writer.write(sbGrammars);
    }

    private void handleResource(StringBuilder sb, Set<Class<?>> jaxbTypes, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, ClassResourceInfo cri, Set<ClassResourceInfo> visitedResources) {
        visitedResources.add(cri);
        List<OperationResourceInfo> sortedOps = this.sortOperationsByPath(cri.getMethodDispatcher().getOperationResourceInfos());
        boolean resourceTagOpened = false;
        for (int i = 0; i < sortedOps.size(); ++i) {
            OperationResourceInfo ori = sortedOps.get(i);
            if (ori.getHttpMethod() == null) {
                Class<?> cls = ori.getMethodToInvoke().getReturnType();
                ClassResourceInfo subcri = cri.findResource(cls, cls);
                if (subcri != null && !visitedResources.contains(subcri)) {
                    this.startResourceTag(sb, subcri.getServiceClass(), ori.getURITemplate().getValue());
                    this.handleDocs(subcri.getServiceClass().getAnnotations(), sb);
                    this.handlePathAndMatrixParams(sb, ori);
                    this.handleResource(sb, jaxbTypes, qnameResolver, clsMap, subcri, visitedResources);
                    sb.append("</resource>");
                    continue;
                }
                this.handleDynamicSubresource(sb, jaxbTypes, qnameResolver, clsMap, ori, subcri);
                continue;
            }
            OperationResourceInfo nextOp = i + 1 < sortedOps.size() ? sortedOps.get(i + 1) : null;
            resourceTagOpened = this.handleOperation(sb, jaxbTypes, qnameResolver, clsMap, ori, nextOp, resourceTagOpened, i);
        }
    }

    private void startResourceTag(StringBuilder sb, Class<?> serviceClass, String path) {
        sb.append("<resource path=\"").append(path).append("\"");
        if (this.addResourceAndMethodIds) {
            QName jaxbQname = null;
            if (this.useJaxbContextForQnames) {
                jaxbQname = this.getJaxbQName(null, serviceClass, new HashMap(0));
            }
            String pName = jaxbQname == null ? PackageUtils.getPackageName(serviceClass) : jaxbQname.getNamespaceURI();
            String localName = jaxbQname == null ? serviceClass.getSimpleName() : jaxbQname.getLocalPart();
            sb.append(" id=\"").append("{" + pName + "}" + localName).append("\"");
        }
        sb.append(">");
    }

    private void startMethodTag(StringBuilder sb, OperationResourceInfo ori) {
        sb.append("<method name=\"").append(ori.getHttpMethod()).append("\"");
        if (this.addResourceAndMethodIds) {
            sb.append(" id=\"").append(ori.getMethodToInvoke().getName()).append("\"");
        }
        sb.append(">");
    }

    private boolean handleOperation(StringBuilder sb, Set<Class<?>> jaxbTypes, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, OperationResourceInfo ori, OperationResourceInfo nextOp, boolean resourceTagOpened, int index) {
        boolean isVoid;
        boolean samePathOperationFollows = this.singleResourceMultipleMethods && this.compareOperations(ori, nextOp);
        String path = ori.getURITemplate().getValue();
        if (!resourceTagOpened && this.openResource(path)) {
            String parentPath;
            resourceTagOpened = true;
            URITemplate template = ori.getClassResourceInfo().getURITemplate();
            if (template != null && (parentPath = template.getValue()).endsWith("/") && path.startsWith("/") && path.length() > 1) {
                path = path.substring(1);
            }
            sb.append("<resource path=\"").append(path).append("\">");
            this.handlePathAndMatrixParams(sb, ori);
        } else if (index == 0) {
            this.handlePathAndMatrixParams(sb, ori);
        }
        this.startMethodTag(sb, ori);
        this.handleDocs(ori.getAnnotatedMethod().getAnnotations(), sb);
        if (ori.getMethodToInvoke().getParameterTypes().length != 0) {
            sb.append("<request>");
            if (this.isFormRequest(ori)) {
                this.handleFormRepresentation(sb, jaxbTypes, qnameResolver, clsMap, ori, this.getFormClass(ori));
            } else {
                for (Parameter p : ori.getParameters()) {
                    this.handleParameter(sb, jaxbTypes, qnameResolver, clsMap, ori, p);
                }
            }
            sb.append("</request>");
        }
        sb.append("<response");
        boolean bl = isVoid = Void.TYPE == ori.getMethodToInvoke().getReturnType();
        if (isVoid) {
            boolean oneway = ori.getMethodToInvoke().getAnnotation(Oneway.class) != null;
            sb.append(" status=\"" + (oneway ? 202 : 204) + "\"");
        }
        sb.append(">");
        if (Void.TYPE != ori.getMethodToInvoke().getReturnType()) {
            this.handleRepresentation(sb, jaxbTypes, qnameResolver, clsMap, ori, ori.getMethodToInvoke().getReturnType(), false);
        }
        sb.append("</response>");
        sb.append("</method>");
        if (resourceTagOpened && !samePathOperationFollows) {
            sb.append("</resource>");
            resourceTagOpened = false;
        }
        return resourceTagOpened;
    }

    protected boolean compareOperations(OperationResourceInfo ori1, OperationResourceInfo ori2) {
        if (ori1 == null || ori2 == null || !ori1.getURITemplate().getValue().equals(ori2.getURITemplate().getValue())) {
            return false;
        }
        int ori1PathParams = 0;
        int ori1MatrixParams = 0;
        for (Parameter p : ori1.getParameters()) {
            if (p.getType() == ParameterType.PATH) {
                ++ori1PathParams;
                continue;
            }
            if (p.getType() != ParameterType.MATRIX) continue;
            ++ori1MatrixParams;
        }
        int ori2PathParams = 0;
        int ori2MatrixParams = 0;
        for (Parameter p : ori2.getParameters()) {
            if (p.getType() == ParameterType.PATH) {
                ++ori2PathParams;
                continue;
            }
            if (p.getType() != ParameterType.MATRIX) continue;
            ++ori2MatrixParams;
        }
        return ori1PathParams == ori2PathParams && ori1MatrixParams == ori2MatrixParams;
    }

    private boolean openResource(String path) {
        if ("/".equals(path)) {
            return this.useSingleSlashResource;
        }
        return true;
    }

    protected void handleDynamicSubresource(StringBuilder sb, Set<Class<?>> jaxbTypes, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, OperationResourceInfo ori, ClassResourceInfo subcri) {
        if (subcri != null) {
            sb.append("<!-- Recursive subresource -->");
        } else {
            sb.append("<!-- Dynamic subresource -->");
        }
        this.startResourceTag(sb, subcri != null ? subcri.getServiceClass() : Object.class, ori.getURITemplate().getValue());
        this.handlePathAndMatrixParams(sb, ori);
        sb.append("</resource>");
    }

    private void handlePathAndMatrixParams(StringBuilder sb, OperationResourceInfo ori) {
        this.handleParams(sb, ori, ParameterType.PATH);
        this.handleParams(sb, ori, ParameterType.MATRIX);
    }

    private void handleParameter(StringBuilder sb, Set<Class<?>> jaxbTypes, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, OperationResourceInfo ori, Parameter pm) {
        Class<?> cls = ori.getMethodToInvoke().getParameterTypes()[pm.getIndex()];
        if (pm.getType() == ParameterType.REQUEST_BODY) {
            this.handleRepresentation(sb, jaxbTypes, qnameResolver, clsMap, ori, cls, true);
            return;
        }
        if (pm.getType() == ParameterType.PATH || pm.getType() == ParameterType.MATRIX) {
            return;
        }
        if (pm.getType() == ParameterType.HEADER || pm.getType() == ParameterType.QUERY) {
            this.writeParam(sb, pm, ori);
        }
    }

    private void handleParams(StringBuilder sb, OperationResourceInfo ori, ParameterType type) {
        for (Parameter pm : ori.getParameters()) {
            if (pm.getType() != type) continue;
            this.writeParam(sb, pm, ori);
        }
    }

    private Annotation[] getBodyAnnotations(OperationResourceInfo ori, boolean inbound) {
        if (inbound) {
            for (Parameter pm : ori.getParameters()) {
                if (pm.getType() != ParameterType.REQUEST_BODY) continue;
                return ori.getAnnotatedMethod().getParameterAnnotations()[pm.getIndex()];
            }
            return new Annotation[0];
        }
        return ori.getAnnotatedMethod().getDeclaredAnnotations();
    }

    private void writeParam(StringBuilder sb, Parameter pm, OperationResourceInfo ori) {
        Class<?> type = ori.getMethodToInvoke().getParameterTypes()[pm.getIndex()];
        if (!"".equals(pm.getName())) {
            this.doWriteParam(sb, pm, type, pm.getName());
        } else {
            this.doWriteBeanParam(sb, type, pm, null);
        }
    }

    private void doWriteBeanParam(StringBuilder sb, Class<?> type, Parameter pm, String parentName) {
        Map<Parameter, Class<?>> pms = InjectionUtils.getParametersFromBeanClass(type, pm.getType(), true);
        for (Map.Entry<Parameter, Class<?>> entry : pms.entrySet()) {
            String name = entry.getKey().getName();
            if (parentName != null) {
                name = parentName + "." + name;
            }
            if (InjectionUtils.isPrimitive(entry.getValue())) {
                this.doWriteParam(sb, entry.getKey(), entry.getValue(), name);
                continue;
            }
            this.doWriteBeanParam(sb, entry.getValue(), entry.getKey(), name);
        }
    }

    protected void doWriteParam(StringBuilder sb, Parameter pm, Class<?> type, String paramName) {
        String value;
        sb.append("<param name=\"").append(paramName).append("\" ");
        String style = ParameterType.PATH == pm.getType() ? "template" : (ParameterType.FORM == pm.getType() ? "query" : (ParameterType.REQUEST_BODY == pm.getType() ? "plain" : pm.getType().toString().toLowerCase()));
        sb.append("style=\"").append(style).append("\"");
        if (pm.getDefaultValue() != null) {
            sb.append(" default=\"").append(pm.getDefaultValue()).append("\"");
        }
        if ((value = XmlSchemaPrimitiveUtils.getSchemaRepresentation(type)) != null) {
            sb.append(" type=\"").append(value).append("\"");
        }
        sb.append("/>");
    }

    private void handleRepresentation(StringBuilder sb, Set<Class<?>> jaxbTypes, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, OperationResourceInfo ori, Class<?> type, boolean inbound) {
        List<MediaType> types;
        List<MediaType> list = types = inbound ? ori.getConsumeTypes() : ori.getProduceTypes();
        if (MultivaluedMap.class.isAssignableFrom(type)) {
            types = Collections.singletonList(MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        } else if (this.isWildcard(types)) {
            types = Collections.singletonList(MediaType.APPLICATION_OCTET_STREAM_TYPE);
        }
        boolean isPrimitive = InjectionUtils.isPrimitive(type);
        for (MediaType mt : types) {
            sb.append("<representation");
            sb.append(" mediaType=\"").append(mt.toString()).append("\"");
            if (isPrimitive) {
                sb.append(">");
                Parameter p = inbound ? this.getRequestBodyParam(ori) : new Parameter(ParameterType.REQUEST_BODY, 0, "result");
                this.doWriteParam(sb, p, type, p.getName() == null ? "request" : p.getName());
                sb.append("</representation>");
                continue;
            }
            type = this.getActualJaxbType(type, ori.getAnnotatedMethod(), inbound);
            if (qnameResolver != null && mt.getSubtype().contains("xml") && jaxbTypes.contains(type)) {
                this.generateQName(sb, qnameResolver, clsMap, type, this.getBodyAnnotations(ori, inbound));
            }
            sb.append("/>");
        }
    }

    private Parameter getRequestBodyParam(OperationResourceInfo ori) {
        for (Parameter p : ori.getParameters()) {
            if (p.getType() != ParameterType.REQUEST_BODY) continue;
            return p;
        }
        throw new IllegalStateException();
    }

    private boolean isWildcard(List<MediaType> types) {
        return types.size() == 1 && types.get(0).equals((Object)MediaType.WILDCARD_TYPE);
    }

    private void handleFormRepresentation(StringBuilder sb, Set<Class<?>> jaxbTypes, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, OperationResourceInfo ori, Class<?> type) {
        if (type != null) {
            this.handleRepresentation(sb, jaxbTypes, qnameResolver, clsMap, ori, type, true);
        } else {
            List<MediaType> types = ori.getConsumeTypes();
            MediaType formType = this.isWildcard(types) ? MediaType.APPLICATION_FORM_URLENCODED_TYPE : types.get(0);
            sb.append("<representation");
            sb.append(" mediaType=\"").append(formType).append("\">");
            for (Parameter pm : ori.getParameters()) {
                this.writeParam(sb, pm, ori);
            }
            sb.append("</representation>");
        }
    }

    protected Class<?> getActualJaxbType(Class<?> type, Method resourceMethod, boolean inbound) {
        WadlElement element = resourceMethod.getAnnotation(WadlElement.class);
        return element == null ? type : (inbound ? element.request() : element.response());
    }

    protected List<OperationResourceInfo> sortOperationsByPath(Set<OperationResourceInfo> ops) {
        LinkedList<OperationResourceInfo> opsWithSamePath = new LinkedList<OperationResourceInfo>(ops);
        Collections.sort(opsWithSamePath, new Comparator<OperationResourceInfo>(){

            @Override
            public int compare(OperationResourceInfo op1, OperationResourceInfo op2) {
                boolean sub2;
                boolean sub1 = op1.getHttpMethod() == null;
                boolean bl = sub2 = op2.getHttpMethod() == null;
                if (sub1 && !sub2) {
                    return 1;
                }
                if (!sub1 && sub2) {
                    return -1;
                }
                URITemplate ut1 = op1.getURITemplate();
                URITemplate ut2 = op2.getURITemplate();
                int result = ut1.getValue().compareTo(ut2.getValue());
                if (!(result != 0 || sub1 && sub2)) {
                    result = op1.getHttpMethod().compareTo(op2.getHttpMethod());
                }
                return result;
            }
        });
        return opsWithSamePath;
    }

    public List<ClassResourceInfo> getResourcesList(Message m, ClassResourceInfo cri) {
        return cri != null ? Collections.singletonList(cri) : ((JAXRSServiceImpl)((Object)m.getExchange().get(Service.class))).getClassResourceInfos();
    }

    private void generateQName(StringBuilder sb, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, Class<?> type, Annotation[] annotations) {
        QName typeQName = clsMap.get(type);
        if (typeQName != null) {
            this.writeQName(sb, typeQName);
            return;
        }
        QName qname = qnameResolver.resolve(type, annotations, Collections.unmodifiableMap(clsMap));
        if (qname != null) {
            this.writeQName(sb, qname);
            clsMap.put(type, qname);
        }
    }

    private void writeQName(StringBuilder sb, QName qname) {
        sb.append(" element=\"").append(qname.getPrefix()).append(':').append(qname.getLocalPart()).append("\"");
    }

    private SchemaCollection getSchemaCollection(JAXBContext context) {
        if (context == null) {
            return null;
        }
        SchemaCollection xmlSchemaCollection = new SchemaCollection();
        HashSet<DOMSource> schemas = new HashSet<DOMSource>();
        try {
            for (DOMResult r : JAXBUtils.generateJaxbSchemas((JAXBContext)context, (Map)CastUtils.cast(Collections.emptyMap(), String.class, DOMResult.class))) {
                schemas.add(new DOMSource(r.getNode(), r.getSystemId()));
            }
        }
        catch (IOException e) {
            LOG.fine("No schema can be generated");
            return null;
        }
        boolean hackAroundEmptyNamespaceIssue = false;
        for (DOMSource r : schemas) {
            hackAroundEmptyNamespaceIssue = this.addSchemaDocument(xmlSchemaCollection, (Document)r.getNode(), r.getSystemId(), hackAroundEmptyNamespaceIssue);
        }
        return xmlSchemaCollection;
    }

    private QName getJaxbQName(JAXBContextProxy jaxbProxy, Class<?> type, Map<Class<?>, QName> clsMap) {
        XmlRootElement root = type.getAnnotation(XmlRootElement.class);
        if (root != null) {
            QName qname = this.getQNameFromParts(root.name(), root.namespace(), clsMap);
            if (qname != null) {
                return qname;
            }
            String ns = JAXBUtils.getPackageNamespace(type);
            if (ns != null) {
                return this.getQNameFromParts(root.name(), ns, clsMap);
            }
            return null;
        }
        try {
            JAXBBeanInfo jaxbInfo;
            JAXBBeanInfo jAXBBeanInfo = jaxbInfo = jaxbProxy == null ? null : JAXBUtils.getBeanInfo((JAXBContextProxy)jaxbProxy, type);
            if (jaxbInfo == null) {
                return null;
            }
            Object instance = type.newInstance();
            return this.getQNameFromParts(jaxbInfo.getElementLocalName(instance), jaxbInfo.getElementNamespaceURI(instance), clsMap);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String getPrefix(String ns, Map<Class<?>, QName> clsMap) {
        String prefix = null;
        for (QName name : clsMap.values()) {
            if (!name.getNamespaceURI().equals(ns)) continue;
            prefix = name.getPrefix();
            break;
        }
        if (prefix == null) {
            int size = new HashSet<QName>(clsMap.values()).size();
            prefix = "prefix" + (size + 1);
        }
        return prefix;
    }

    private boolean isFormRequest(OperationResourceInfo ori) {
        for (Parameter p : ori.getParameters()) {
            if (p.getType() != ParameterType.FORM && (p.getType() != ParameterType.REQUEST_BODY || ori.getMethodToInvoke().getParameterTypes()[p.getIndex()] != MultivaluedMap.class)) continue;
            return true;
        }
        return false;
    }

    private Class<?> getFormClass(OperationResourceInfo ori) {
        if (ori.getParameters().get(0).getType() == ParameterType.FORM) {
            return null;
        }
        return MultivaluedMap.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSchemaDocument(SchemaCollection col, Document d, String systemId, boolean hackAroundEmptyNamespaceIssue) {
        String ns = d.getDocumentElement().getAttribute("targetNamespace");
        if (StringUtils.isEmpty((String)ns)) {
            if (DOMUtils.getFirstElement((Node)d.getDocumentElement()) == null) {
                hackAroundEmptyNamespaceIssue = true;
                return hackAroundEmptyNamespaceIssue;
            }
            d = this.copy(d);
            ns = "";
            d.getDocumentElement().setAttribute("targetNamespace", ns);
        }
        if (hackAroundEmptyNamespaceIssue) {
            d = this.doEmptyNamespaceHack(d);
        }
        for (Node n = d.getDocumentElement().getFirstChild(); n != null; n = n.getNextSibling()) {
            Element e;
            if (!(n instanceof Element) || !(e = (Element)n).getLocalName().equals("import")) continue;
            e.removeAttribute("schemaLocation");
        }
        Document document = d;
        synchronized (document) {
            col.read(d, systemId, null);
        }
        return hackAroundEmptyNamespaceIssue;
    }

    private Document doEmptyNamespaceHack(Document d) {
        boolean hasStuffToRemove = false;
        Element el = DOMUtils.getFirstElement((Node)d.getDocumentElement());
        while (el != null) {
            if ("import".equals(el.getLocalName()) && StringUtils.isEmpty((String)el.getAttribute("targetNamespace"))) {
                hasStuffToRemove = true;
                break;
            }
            el = DOMUtils.getNextElement((Element)el);
        }
        if (hasStuffToRemove) {
            d = this.copy(d);
            el = DOMUtils.getFirstElement((Node)d.getDocumentElement());
            while (el != null) {
                if ("import".equals(el.getLocalName()) && StringUtils.isEmpty((String)el.getAttribute("targetNamespace"))) {
                    d.getDocumentElement().removeChild(el);
                    el = DOMUtils.getFirstElement((Node)d.getDocumentElement());
                    continue;
                }
                el = DOMUtils.getNextElement((Element)el);
            }
        }
        return d;
    }

    private Document copy(Document doc) {
        try {
            return StaxUtils.copy((Document)doc);
        }
        catch (XMLStreamException e) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return doc;
    }

    private QName getQNameFromParts(String name, String namespace, Map<Class<?>, QName> clsMap) {
        if (name == null || "##default".equals(name) || name.length() == 0) {
            return null;
        }
        if (namespace == null || "##default".equals(namespace) || namespace.length() == 0) {
            return null;
        }
        String prefix = this.getPrefix(namespace, clsMap);
        return new QName(namespace, name, prefix);
    }

    public void setIgnoreMessageWriters(boolean ignoreMessageWriters) {
        this.ignoreMessageWriters = ignoreMessageWriters;
    }

    private void handleDocs(Annotation[] anns, StringBuilder sb) {
        for (Annotation a : anns) {
            if (a.annotationType() != Description.class) continue;
            Description d = (Description)a;
            sb.append("<doc");
            if (d.lang().length() > 0) {
                sb.append(" xml:lang=\"" + d.lang() + "\"");
            }
            if (d.title().length() > 0) {
                sb.append(" title=\"" + d.title() + "\"");
            }
            sb.append(">");
            if (d.value().length() > 0) {
                sb.append(d.value());
            } else if (d.docuri().length() > 0) {
                String path;
                InputStream is = null;
                if (d.docuri().startsWith(CLASSPATH_PREFIX) && (is = ResourceUtils.getClasspathResourceStream(path = d.docuri().substring(CLASSPATH_PREFIX.length()), SchemaHandler.class, BusFactory.getDefaultBus())) != null) {
                    try {
                        sb.append(IOUtils.toString((InputStream)is));
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
            }
            sb.append("</doc>");
        }
    }

    private String getNamespace() {
        return this.wadlNamespace != null ? this.wadlNamespace : WADL_NS;
    }

    public void setWadlNamespace(String namespace) {
        this.wadlNamespace = namespace;
    }

    public void setSingleResourceMultipleMethods(boolean singleResourceMultipleMethods) {
        this.singleResourceMultipleMethods = singleResourceMultipleMethods;
    }

    public void setUseSingleSlashResource(boolean useSingleSlashResource) {
        this.useSingleSlashResource = useSingleSlashResource;
    }

    public void setSchemaLocations(List<String> locations) {
        this.externalQnamesMap = new HashMap<String, List<String>>();
        this.externalSchemasCache = new ArrayList<String>(locations.size());
        for (int i = 0; i < locations.size(); ++i) {
            String loc = locations.get(i);
            try {
                InputStream is = ResourceUtils.getResourceStream(loc, BusFactory.getDefaultBus());
                if (is == null) {
                    return;
                }
                ByteArrayInputStream bis = IOUtils.loadIntoBAIS((InputStream)is);
                XMLSource source = new XMLSource(bis);
                source.setBuffering(true);
                String targetNs = source.getValue("/*/@targetNamespace");
                Map<String, String> nsMap = Collections.singletonMap("xs", "http://www.w3.org/2001/XMLSchema");
                String[] elementNames = source.getValues("/*/xs:element/@name", nsMap);
                this.externalQnamesMap.put(targetNs, Arrays.asList(elementNames));
                String schemaValue = source.getNode("/xs:schema", nsMap, String.class);
                this.externalSchemasCache.add(schemaValue);
                continue;
            }
            catch (Exception ex) {
                LOG.warning("No schema resource " + loc + " can be loaded : " + ex.getMessage());
                this.externalSchemasCache = null;
                this.externalQnamesMap = null;
                return;
            }
        }
    }

    public void setUseJaxbContextForQnames(boolean checkJaxbOnly) {
        this.useJaxbContextForQnames = checkJaxbOnly;
    }

    protected ElementQNameResolver createElementQNameResolver(JAXBContext context) {
        if (this.resolver != null) {
            return this.resolver;
        }
        if (this.useJaxbContextForQnames) {
            if (context != null) {
                JAXBContextProxy proxy = (JAXBContextProxy)ReflectionInvokationHandler.createProxyWrapper((Object)context, JAXBContextProxy.class);
                return new JaxbContextQNameResolver(proxy);
            }
            return null;
        }
        if (this.externalQnamesMap != null) {
            return new SchemaQNameResolver(this.externalQnamesMap);
        }
        return new XMLNameQNameResolver();
    }

    protected SchemaWriter createSchemaWriter(JAXBContext context, UriInfo ui) {
        SchemaCollection coll;
        if (this.externalSchemaLinks != null && this.externalSchemasCache == null) {
            return new ExternalSchemaWriter(this.externalSchemaLinks, ui);
        }
        if (this.externalSchemasCache != null) {
            return new StringSchemaWriter(this.externalSchemasCache, this.externalSchemaLinks, ui);
        }
        if (context != null && (coll = this.getSchemaCollection(context)) != null) {
            return new SchemaCollectionWriter(coll);
        }
        return null;
    }

    public void setExternalLinks(List<String> externalLinks) {
        this.externalSchemaLinks = new LinkedList<URI>();
        for (String s : externalLinks) {
            try {
                this.externalSchemaLinks.add(URI.create(s));
            }
            catch (Exception ex) {
                LOG.warning("Not a valid URI : " + s);
                this.externalSchemaLinks = null;
                break;
            }
        }
    }

    public void setResolver(ElementQNameResolver resolver) {
        this.resolver = resolver;
    }

    public void setPrivateAddresses(List<String> privateAddresses) {
        this.privateAddresses = privateAddresses;
    }

    public List<String> getPrivateAddresses() {
        return this.privateAddresses;
    }

    private boolean isPrivate(Message m) {
        return MessageUtils.isTrue((Object)m.getContextualProperty("org.apache.cxf.endpoint.private"));
    }

    public void setAddResourceAndMethodIds(boolean addResourceAndMethodIds) {
        this.addResourceAndMethodIds = addResourceAndMethodIds;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SchemaConverter
    extends DelegatingXMLStreamWriter {
        private static final String SCHEMA_LOCATION = "schemaLocation";
        private Map<String, String> locsMap;

        public SchemaConverter(XMLStreamWriter writer, Map<String, String> locsMap) {
            super(writer);
            this.locsMap = locsMap;
        }

        public void writeAttribute(String local, String value) throws XMLStreamException {
            if (SCHEMA_LOCATION.equals(local) && this.locsMap.containsKey(value)) {
                value = this.locsMap.get(value);
            }
            super.writeAttribute(local, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SchemaQNameResolver
    implements ElementQNameResolver {
        private Map<String, List<String>> map;

        public SchemaQNameResolver(Map<String, List<String>> map) {
            this.map = map;
        }

        @Override
        public QName resolve(Class<?> type, Annotation[] annotations, Map<Class<?>, QName> clsMap) {
            String name = type.getSimpleName();
            for (Map.Entry<String, List<String>> entry : this.map.entrySet()) {
                String elementName = null;
                if (entry.getValue().contains(name)) {
                    elementName = name;
                } else if (entry.getValue().contains(name.toLowerCase())) {
                    elementName = name.toLowerCase();
                }
                if (elementName == null) continue;
                return WadlGenerator.this.getQNameFromParts(elementName, entry.getKey(), clsMap);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class XMLNameQNameResolver
    implements ElementQNameResolver {
        private XMLNameQNameResolver() {
        }

        @Override
        public QName resolve(Class<?> type, Annotation[] annotations, Map<Class<?>, QName> clsMap) {
            XMLName name = AnnotationUtils.getAnnotation(annotations, XMLName.class);
            if (name == null) {
                name = type.getAnnotation(XMLName.class);
            }
            if (name != null) {
                QName qname = JAXRSUtils.convertStringToQName(name.value(), name.prefix());
                if (qname.getPrefix().length() > 0) {
                    return qname;
                }
                return WadlGenerator.this.getQNameFromParts(qname.getLocalPart(), qname.getNamespaceURI(), clsMap);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JaxbContextQNameResolver
    implements ElementQNameResolver {
        private JAXBContextProxy proxy;

        public JaxbContextQNameResolver(JAXBContextProxy proxy) {
            this.proxy = proxy;
        }

        @Override
        public QName resolve(Class<?> type, Annotation[] annotations, Map<Class<?>, QName> clsMap) {
            return WadlGenerator.this.getJaxbQName(this.proxy, type, clsMap);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExternalSchemaWriter
    implements SchemaWriter {
        private List<URI> links;
        private UriInfo uriInfo;

        public ExternalSchemaWriter(List<URI> links, UriInfo ui) {
            this.links = links;
            this.uriInfo = ui;
        }

        @Override
        public void write(StringBuilder sb) {
            for (URI link : this.links) {
                try {
                    URI value = link.isAbsolute() ? link : this.uriInfo.getBaseUriBuilder().path(link.toString()).build(new Object[0]);
                    sb.append("<include href=\"").append(value.toString()).append("\"/>");
                }
                catch (Exception ex) {
                    LOG.warning("WADL grammar section will be incomplete, this link is not a valid URI : " + link.toString());
                }
            }
        }
    }

    private class SchemaCollectionWriter
    implements SchemaWriter {
        private SchemaCollection coll;

        public SchemaCollectionWriter(SchemaCollection coll) {
            this.coll = coll;
        }

        public void write(StringBuilder sb) {
            for (XmlSchema xs : this.coll.getXmlSchemas()) {
                if (xs.getItems().getCount() == 0) continue;
                StringWriter writer = new StringWriter();
                xs.write((Writer)writer);
                sb.append(writer.toString());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StringSchemaWriter
    implements SchemaWriter {
        private List<String> theSchemas = new LinkedList<String>();

        public StringSchemaWriter(List<String> schemas, List<URI> links, UriInfo ui) {
            for (String s : schemas) {
                XMLSource source = new XMLSource(new ByteArrayInputStream(s.getBytes()));
                source.setBuffering(true);
                Map<String, String> locs = this.getLocationsMap(source, "import", links, ui);
                String actualSchema = !locs.isEmpty() ? this.transformSchema(s, locs) : s;
                this.theSchemas.add(actualSchema);
            }
        }

        private Map<String, String> getLocationsMap(XMLSource source, String elementName, List<URI> links, UriInfo ui) {
            Map<String, String> nsMap = Collections.singletonMap("xs", "http://www.w3.org/2001/XMLSchema");
            String[] locations = source.getValues("/*/xs:" + elementName + "/@schemaLocation", nsMap);
            if (locations == null) {
                return Collections.emptyMap();
            }
            HashMap<String, String> locs = new HashMap<String, String>();
            for (String loc : locations) {
                try {
                    URI uri = URI.create(loc);
                    if (uri.isAbsolute()) continue;
                    if (links != null) {
                        for (URI overwriteURI : links) {
                            if (!overwriteURI.toString().endsWith(loc)) continue;
                            if (overwriteURI.isAbsolute()) {
                                locs.put(loc, overwriteURI.toString());
                                break;
                            }
                            locs.put(loc, ui.getBaseUriBuilder().path(overwriteURI.toString()).build(new Object[0]).toString());
                            break;
                        }
                    }
                    if (locs.containsKey(loc)) continue;
                    locs.put(loc, ui.getBaseUriBuilder().path(loc.toString()).build(new Object[0]).toString());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return locs;
        }

        private String transformSchema(String schema, Map<String, String> locs) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            SchemaConverter sc = new SchemaConverter(StaxUtils.createXMLStreamWriter((OutputStream)bos), locs);
            try {
                StaxUtils.copy((Source)new StreamSource(new StringReader(schema)), (XMLStreamWriter)((Object)sc));
                sc.flush();
                sc.close();
                return bos.toString();
            }
            catch (Exception ex) {
                return schema;
            }
        }

        @Override
        public void write(StringBuilder sb) {
            for (String s : this.theSchemas) {
                sb.append(s);
            }
        }
    }

    private static interface SchemaWriter {
        public void write(StringBuilder var1);
    }
}

