/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLSource {
    private static final Logger LOG = LogUtils.getL7dLogger(XMLSource.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(XMLSource.class);
    private static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private InputStream stream;
    private boolean buffering;
    private boolean markFailed;

    public XMLSource(InputStream is) {
        this.stream = is;
    }

    public void setBuffering(boolean enable) {
        this.buffering = enable;
        if (!this.stream.markSupported()) {
            try {
                this.stream = IOUtils.loadIntoBAIS((InputStream)this.stream);
            }
            catch (IOException ex) {
                LOG.warning(new Message("NO_SOURCE_MARK", BUNDLE, new Object[0]).toString());
            }
        }
    }

    public <T> T getNode(String expression, Class<T> cls) {
        return this.getNode(expression, CastUtils.cast(Collections.emptyMap(), String.class, String.class), cls);
    }

    public <T> T getNode(String expression, Map<String, String> namespaces, Class<T> cls) {
        Node node = (Node)this.evaluate(expression, namespaces, XPathConstants.NODE);
        if (node == null) {
            return null;
        }
        if (cls.isPrimitive() || cls == String.class) {
            return this.readPrimitiveValue(node, cls);
        }
        return this.readNode(node, cls);
    }

    public <T> T[] getNodes(String expression, Class<T> cls) {
        return this.getNodes(expression, CastUtils.cast(Collections.emptyMap(), String.class, String.class), cls);
    }

    public <T> T[] getNodes(String expression, Map<String, String> namespaces, Class<T> cls) {
        NodeList nodes = (NodeList)this.evaluate(expression, namespaces, XPathConstants.NODESET);
        if (nodes == null || nodes.getLength() == 0) {
            return null;
        }
        Object[] values = (Object[])Array.newInstance(cls, nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            values[i] = InjectionUtils.isPrimitive(cls) ? this.readPrimitiveValue(node, cls) : this.readNode(node, cls);
        }
        return values;
    }

    public URI getLink(String expression) {
        return this.getLink(expression, CastUtils.cast(Collections.emptyMap(), String.class, String.class));
    }

    public URI getLink(String expression, Map<String, String> namespaces) {
        String value = this.getValue(expression, namespaces);
        return value == null ? null : URI.create(value);
    }

    public URI[] getLinks(String expression, Map<String, String> namespaces) {
        String[] values = this.getValues(expression, namespaces);
        if (values == null) {
            return null;
        }
        URI[] uris = new URI[values.length];
        for (int i = 0; i < values.length; ++i) {
            uris[i] = URI.create(values[i]);
        }
        return uris;
    }

    public URI getBaseURI() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("xml", XML_NAMESPACE);
        return this.getLink("/*/@xml:base", map);
    }

    public String getValue(String expression) {
        return this.getValue(expression, CastUtils.cast(Collections.emptyMap(), String.class, String.class));
    }

    public String getValue(String expression, Map<String, String> namespaces) {
        return this.getValue(expression, namespaces, String.class);
    }

    public String[] getValues(String expression) {
        return this.getValues(expression, CastUtils.cast(Collections.emptyMap(), String.class, String.class));
    }

    public String[] getValues(String expression, Map<String, String> namespaces) {
        return this.getNodes(expression, namespaces, String.class);
    }

    public <T> T getValue(String expression, Map<String, String> namespaces, Class<T> cls) {
        Object result = this.evaluate(expression, namespaces, XPathConstants.STRING);
        return result == null ? null : (T)InjectionUtils.convertStringToPrimitive(result.toString(), cls);
    }

    private Object evaluate(String expression, Map<String, String> namespaces, QName type) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(new NamespaceContextImpl(namespaces));
        try {
            return xpath.evaluate(expression, this.getSource(), type);
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException("Illegal XPath expression '" + expression + "'", ex);
        }
    }

    private <T> T readPrimitiveValue(Node node, Class<T> cls) {
        if (String.class == cls) {
            if (node.getNodeType() == 1) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                XMLUtils.writeTo((Source)new DOMSource(node), (OutputStream)bos, (int)0, (String)"", (String)"yes");
                try {
                    return cls.cast(bos.toString("UTF-8"));
                }
                catch (UnsupportedEncodingException ex) {
                }
            } else {
                return cls.cast(node.getNodeValue());
            }
        }
        return InjectionUtils.convertStringToPrimitive(node.getNodeValue(), cls);
    }

    private <T> T readNode(Node node, Class<T> cls) {
        if (Node.class.isAssignableFrom(cls)) {
            return cls.cast(node);
        }
        DOMSource s = new DOMSource(node);
        if (Source.class == cls || DOMSource.class == cls) {
            return cls.cast(s);
        }
        try {
            JAXBElementProvider provider = new JAXBElementProvider();
            JAXBContext c = provider.getPackageContext(cls);
            if (c == null) {
                c = provider.getClassContext(cls);
            }
            Unmarshaller u = c.createUnmarshaller();
            if (cls.getAnnotation(XmlRootElement.class) != null) {
                return cls.cast(u.unmarshal((Source)s));
            }
            return (T)u.unmarshal((Source)s, cls).getValue();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private InputSource getSource() {
        if (!this.markFailed && this.buffering) {
            try {
                this.stream.reset();
                this.stream.mark(this.stream.available());
            }
            catch (IOException ex) {
                LOG.fine(new Message("NO_SOURCE_MARK", BUNDLE, new Object[0]).toString());
                this.markFailed = true;
                try {
                    this.stream = IOUtils.loadIntoBAIS((InputStream)this.stream);
                }
                catch (IOException ex2) {
                    throw new RuntimeException(ex2);
                }
            }
        }
        return new InputSource(this.stream);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NamespaceContextImpl
    implements NamespaceContext {
        private Map<String, String> namespaces;

        public NamespaceContextImpl(Map<String, String> namespaces) {
            this.namespaces = namespaces;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.namespaces.get(prefix);
        }

        @Override
        public String getPrefix(String namespace) {
            for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
                if (!entry.getValue().equals(namespace)) continue;
                return entry.getKey();
            }
            return null;
        }

        public Iterator<?> getPrefixes(String namespace) {
            String prefix = this.namespaces.get(namespace);
            if (prefix == null) {
                return null;
            }
            return Collections.singletonList(prefix).iterator();
        }
    }
}

