/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.ext.multipart.InputStreamDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
public class DataSourceProvider
implements MessageBodyReader,
MessageBodyWriter {
    private boolean useDataSourceContentType;

    public boolean isReadable(Class type, Type genericType, Annotation[] annotations, MediaType mt) {
        return this.isSupported(type, mt);
    }

    public Object readFrom(Class cls, Type genericType, Annotation[] annotations, MediaType type, MultivaluedMap headers, InputStream is) throws IOException {
        InputStreamDataSource ds = new InputStreamDataSource(is, type.toString());
        return DataSource.class.isAssignableFrom(cls) ? ds : new DataHandler((DataSource)ds);
    }

    public long getSize(Object t, Class type, Type genericType, Annotation[] annotations, MediaType mt) {
        return -1L;
    }

    public boolean isWriteable(Class type, Type genericType, Annotation[] annotations, MediaType mt) {
        return this.isSupported(type, mt);
    }

    private boolean isSupported(Class<?> type, MediaType mt) {
        return !mt.getType().equals("multipart") && (DataSource.class.isAssignableFrom(type) || DataHandler.class.isAssignableFrom(type));
    }

    public void writeTo(Object src, Class cls, Type genericType, Annotation[] annotations, MediaType type, MultivaluedMap headers, OutputStream os) throws IOException {
        DataSource ds;
        DataSource dataSource = ds = DataSource.class.isAssignableFrom(cls) ? (DataSource)src : ((DataHandler)src).getDataSource();
        if (this.useDataSourceContentType) {
            this.setContentTypeIfNeeded(type, headers, ds.getContentType());
        }
        IOUtils.copy((InputStream)ds.getInputStream(), (OutputStream)os);
    }

    private void setContentTypeIfNeeded(MediaType type, MultivaluedMap headers, String ct) {
        if (!StringUtils.isEmpty((String)ct) && !type.equals((Object)MediaType.valueOf((String)ct))) {
            headers.putSingle((Object)"Content-Type", (Object)ct);
        }
    }

    public void setUseDataSourceContentType(boolean useDataSourceContentType) {
        this.useDataSourceContentType = useDataSourceContentType;
    }
}

