/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.multipart;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.common.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentDisposition {
    private List<String> values;

    public ContentDisposition(String value) {
        this.values = Arrays.asList(StringUtils.split((String)value, (String)";"));
    }

    public String getType() {
        return this.values.get(0).trim();
    }

    public String getParameter(String name) {
        for (int i = 1; i < this.values.size(); ++i) {
            String v = this.values.get(i).trim();
            if (!v.startsWith(name)) continue;
            String[] parts = StringUtils.split((String)v, (String)"=");
            return parts.length == 2 ? parts[1].trim().replace("\"", "").replace("'", "") : "";
        }
        return null;
    }

    public Map<String, String> getParameters() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 1; i < this.values.size(); ++i) {
            String[] parts = StringUtils.split((String)this.values.get(i), (String)"=");
            map.put(parts[0].trim(), parts.length == 2 ? parts[1].trim().replace("\"", "").replace("'", "") : "");
        }
        return map;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.values.size(); ++i) {
            if (this.values.get(i).length() == 0) continue;
            sb.append(this.values.get(i));
            if (i + 1 >= this.values.size()) continue;
            sb.append(';');
        }
        return sb.toString();
    }
}

