/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.Map;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.apache.cxf.jaxrs.impl.ConfigurationImpl;
import org.apache.cxf.jaxrs.impl.FeatureContextImpl;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;

public class ConfigurableImpl<C extends Configurable<C>>
implements Configurable<C> {
    private ConfigurationImpl config;
    private final C configurable;
    private final Class<?>[] supportedProviderClasses;
    private final Instantiator instantiator = new Instantiator(){

        @Override
        public <T> Object create(Class<T> cls) {
            return ConfigurationImpl.createProvider(cls);
        }
    };

    public ConfigurableImpl(C configurable, RuntimeType rt, Class<?>[] supportedProviderClasses) {
        this(configurable, supportedProviderClasses, new ConfigurationImpl(rt));
    }

    public ConfigurableImpl(C configurable, Class<?>[] supportedProviderClasses, Configuration config) {
        this(configurable, supportedProviderClasses);
        this.config = config instanceof ConfigurationImpl ? (ConfigurationImpl)config : new ConfigurationImpl(config, supportedProviderClasses);
    }

    private ConfigurableImpl(C configurable, Class<?>[] supportedProviderClasses) {
        this.configurable = configurable;
        this.supportedProviderClasses = supportedProviderClasses;
    }

    protected C getConfigurable() {
        return this.configurable;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public C property(String name, Object value) {
        this.config.setProperty(name, value);
        return this.configurable;
    }

    public C register(Object provider) {
        return this.register(provider, AnnotationUtils.getBindingPriority(provider.getClass()));
    }

    public C register(Object provider, int bindingPriority) {
        return this.doRegister(provider, bindingPriority, this.supportedProviderClasses);
    }

    public C register(Object provider, Class<?> ... contracts) {
        return this.doRegister(provider, 5000, contracts);
    }

    public C register(Object provider, Map<Class<?>, Integer> contracts) {
        return this.doRegisterProvider(provider, contracts);
    }

    public C register(Class<?> providerClass) {
        return this.register(providerClass, AnnotationUtils.getBindingPriority(providerClass));
    }

    public C register(Class<?> providerClass, int bindingPriority) {
        return this.doRegister(this.getInstantiator().create(providerClass), bindingPriority, this.supportedProviderClasses);
    }

    public C register(Class<?> providerClass, Class<?> ... contracts) {
        return this.doRegister(providerClass, 5000, contracts);
    }

    public C register(Class<?> providerClass, Map<Class<?>, Integer> contracts) {
        return this.register(this.getInstantiator().create(providerClass), contracts);
    }

    protected Instantiator getInstantiator() {
        return this.instantiator;
    }

    private C doRegister(Object provider, int bindingPriority, Class<?> ... contracts) {
        return this.doRegisterProvider(provider, ConfigurationImpl.initContractsMap(bindingPriority, contracts));
    }

    private C doRegisterProvider(Object provider, Map<Class<?>, Integer> contracts) {
        if (provider instanceof Feature) {
            Feature feature = (Feature)provider;
            boolean enabled = feature.configure((FeatureContext)new FeatureContextImpl(this));
            this.config.setFeature(feature, enabled);
            return this.configurable;
        }
        this.config.register(provider, contracts);
        return this.configurable;
    }

    public static interface Instantiator {
        public <T> Object create(Class<T> var1);
    }
}

