/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.browser.client.ui.browser;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.http.client.URL;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.cxf.management.web.browser.client.event.ChangedFilterOptionsEvent;
import org.apache.cxf.management.web.browser.client.event.ChangedFilterOptionsEventHandler;
import org.apache.cxf.management.web.browser.client.event.ChangedSubscriptionsEvent;
import org.apache.cxf.management.web.browser.client.event.ChangedSubscriptionsEventHandler;
import org.apache.cxf.management.web.browser.client.event.GoToEditCriteriaEvent;
import org.apache.cxf.management.web.browser.client.event.GoToSettingsEvent;
import org.apache.cxf.management.web.browser.client.event.SelectedSubscriptionEvent;
import org.apache.cxf.management.web.browser.client.service.browser.FilterOptions;
import org.apache.cxf.management.web.browser.client.service.settings.SettingsFacade;
import org.apache.cxf.management.web.browser.client.service.settings.Subscription;
import org.apache.cxf.management.web.browser.client.ui.BasePresenter;
import org.apache.cxf.management.web.browser.client.ui.BindStrategy;
import org.apache.cxf.management.web.browser.client.ui.browser.NavigationSidebarView;

@Singleton
public class NavigationSidebarPresenter
extends BasePresenter
implements NavigationSidebarView.Presenter {
    @Nonnull
    private final NavigationSidebarView view;
    @Nonnull
    private final SettingsFacade settingsManager;
    @Nonnull
    private FilterOptions filterOptions = FilterOptions.EMPTY;
    @Nullable
    private Subscription selectedSubscriptionInExplorer;
    @Nullable
    private Subscription selectedSubscriptionInFilter;
    @Nonnull
    private List<Subscription> subscriptions;

    @Inject
    public NavigationSidebarPresenter(@Nonnull EventBus eventBus, @Nonnull NavigationSidebarView view, @Nonnull @Named(value="BindStrategyForNavigationSidebar") BindStrategy bindStrategy, @Nonnull SettingsFacade settingsManager) {
        super(eventBus, view, bindStrategy);
        this.view = view;
        this.view.setPresenter(this);
        this.settingsManager = settingsManager;
        this.bind();
        this.updateSubscriptions();
    }

    public void onExploreSubcriptionItemClicked(int row) {
        assert (row >= 0 && row < this.subscriptions.size());
        this.selectedSubscriptionInExplorer = this.subscriptions.get(row);
        this.selectedSubscriptionInFilter = null;
        this.eventBus.fireEvent((GwtEvent)new SelectedSubscriptionEvent(this.selectedSubscriptionInExplorer.getUrl()));
    }

    public void onFilterSubcriptionItemClicked(int row) {
        assert (row >= 0 && row < this.subscriptions.size());
        this.selectedSubscriptionInFilter = this.subscriptions.get(row);
        this.selectedSubscriptionInExplorer = null;
        this.selectSubscriptionWithFilterOptions();
    }

    private void selectSubscriptionWithFilterOptions() {
        assert (this.selectedSubscriptionInFilter != null);
        StringBuilder url = new StringBuilder(this.selectedSubscriptionInFilter.getUrl());
        if (this.filterOptions != FilterOptions.EMPTY) {
            url.append("?_s=");
            DateTimeFormat dateTimeFormatter = DateTimeFormat.getFormat((String)"yyyy-MM-dd");
            boolean isFirstAttribute = true;
            if (this.filterOptions.getPhrase() != null && !"".equals(this.filterOptions.getPhrase())) {
                url.append("message==*");
                url.append(this.filterOptions.getPhrase());
                url.append("*;");
                isFirstAttribute = false;
            }
            if (this.filterOptions.getFrom() != null) {
                url.append("date=ge=");
                url.append(dateTimeFormatter.format(this.filterOptions.getFrom()));
                url.append(";");
                isFirstAttribute = false;
            }
            if (this.filterOptions.getTo() != null) {
                url.append("date=lt=");
                url.append(dateTimeFormatter.format(this.filterOptions.getTo()));
                url.append(";");
                isFirstAttribute = false;
            }
            if (!this.filterOptions.getLevels().isEmpty()) {
                if (!isFirstAttribute) {
                    url.append("(");
                }
                for (FilterOptions.Level level : this.filterOptions.getLevels()) {
                    url.append("level==");
                    url.append((Object)level);
                    url.append(",");
                }
                url.deleteCharAt(url.length() - 1);
                if (!isFirstAttribute) {
                    url.append(")");
                }
            } else {
                url.deleteCharAt(url.length() - 1);
            }
        }
        this.eventBus.fireEvent((GwtEvent)new SelectedSubscriptionEvent(URL.encode((String)url.toString())));
    }

    public void onManageSubscriptionsButtonClicked() {
        this.eventBus.fireEvent((GwtEvent)new GoToSettingsEvent());
    }

    public void onEditCriteriaHyperinkClicked() {
        this.eventBus.fireEvent((GwtEvent)new GoToEditCriteriaEvent());
    }

    private void updateSubscriptions() {
        this.subscriptions = this.settingsManager.getSubscriptions();
        this.view.setSubscriptions(this.subscriptions);
    }

    private void bind() {
        this.eventBus.addHandler(ChangedSubscriptionsEvent.TYPE, (EventHandler)new ChangedSubscriptionsEventHandler(){

            public void onChangedSubscriptions(ChangedSubscriptionsEvent event) {
                NavigationSidebarPresenter.this.updateSubscriptions();
            }
        });
        this.eventBus.addHandler(ChangedFilterOptionsEvent.TYPE, (EventHandler)new ChangedFilterOptionsEventHandler(){

            public void onChangedFilterOptions(ChangedFilterOptionsEvent event) {
                NavigationSidebarPresenter.this.filterOptions = event.getFilterOptions();
                if (NavigationSidebarPresenter.this.selectedSubscriptionInFilter != null) {
                    NavigationSidebarPresenter.this.selectSubscriptionWithFilterOptions();
                }
            }
        });
    }
}

