/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.logging.atom.converter;

import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.model.Feed;
import org.apache.commons.lang.Validate;
import org.apache.cxf.jaxrs.ext.atom.AbstractEntryBuilder;
import org.apache.cxf.jaxrs.ext.atom.AbstractFeedBuilder;
import org.apache.cxf.management.web.logging.LogRecord;
import org.apache.cxf.management.web.logging.LogRecords;
import org.apache.cxf.management.web.logging.atom.converter.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardConverter
implements Converter {
    private Factory factory;
    private JAXBContext context;
    private DateFormat df;
    private Converter worker;
    private AbstractFeedBuilder<List<LogRecord>> feedBuilder;
    private AbstractEntryBuilder<List<LogRecord>> entryBuilder;

    public StandardConverter(Output output, Multiplicity multiplicity, Format format) {
        this(output, multiplicity, format, null, null);
    }

    public StandardConverter(Output output, Multiplicity multiplicity, Format format, AbstractFeedBuilder<List<LogRecord>> feedBuilder, AbstractEntryBuilder<List<LogRecord>> entryBuilder) {
        Validate.notNull((Object)((Object)output), (String)"output is null");
        Validate.notNull((Object)((Object)multiplicity), (String)"multiplicity is null");
        Validate.notNull((Object)((Object)format), (String)"format is null");
        this.feedBuilder = feedBuilder;
        this.entryBuilder = entryBuilder;
        this.configure(output, multiplicity, format);
        this.df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        this.factory = Abdera.getNewFactory();
        try {
            this.context = JAXBContext.newInstance((Class[])new Class[]{LogRecords.class, LogRecord.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<? extends Element> convert(List<LogRecord> records) {
        return this.worker.convert(records);
    }

    private void configure(Output output, Multiplicity multiplicity, final Format format) {
        if (output == Output.ENTRY && multiplicity == Multiplicity.ONE) {
            this.worker = new Converter(){

                public List<Entry> convert(List<LogRecord> records) {
                    return StandardConverter.this.createEntries(format, records);
                }
            };
        }
        if (output == Output.ENTRY && multiplicity == Multiplicity.MANY) {
            this.worker = new Converter(){

                public List<Entry> convert(List<LogRecord> records) {
                    return Arrays.asList(StandardConverter.this.createEntryFromList(format, records));
                }
            };
        }
        if (output == Output.FEED && multiplicity == Multiplicity.ONE) {
            this.worker = new Converter(){

                public List<Feed> convert(List<LogRecord> records) {
                    return Arrays.asList(StandardConverter.this.createFeedWithSingleEntry(format, records));
                }
            };
        }
        if (output == Output.FEED && multiplicity == Multiplicity.MANY) {
            this.worker = new Converter(){

                public List<Feed> convert(List<LogRecord> records) {
                    return Arrays.asList(StandardConverter.this.createFeed(format, records));
                }
            };
        }
        if (this.worker == null) {
            throw new IllegalArgumentException("Unsupported configuration");
        }
    }

    private List<Entry> createEntries(Format format, List<LogRecord> records) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (int i = 0; i < records.size(); ++i) {
            entries.add(this.createEntryFromRecord(format, records.get(i), i));
        }
        return entries;
    }

    private Entry createEntryFromList(Format format, List<LogRecord> records) {
        Entry e = this.createEntry(records, 0);
        if (format == Format.CONTENT) {
            this.setEntryContent(e, this.createContent(records));
        } else {
            this.setEntryContent(e, this.createExtension(records));
        }
        return e;
    }

    private Entry createEntryFromRecord(Format format, LogRecord record, int entryIndex) {
        Entry e = this.createEntry(Collections.singletonList(record), entryIndex);
        if (format == Format.CONTENT) {
            this.setEntryContent(e, this.createContent(record));
        } else {
            this.setEntryContent(e, this.createExtension(record));
        }
        return e;
    }

    private String createContent(LogRecord record) {
        StringWriter writer = new StringWriter();
        try {
            this.context.createMarshaller().marshal((Object)record, (Writer)writer);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    private String createContent(List<LogRecord> records) {
        StringWriter writer = new StringWriter();
        LogRecords list = new LogRecords();
        list.setLogRecords(records);
        try {
            this.context.createMarshaller().marshal((Object)list, (Writer)writer);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    private ExtensibleElement createExtension(LogRecord record) {
        ExtensibleElement erec = (ExtensibleElement)this.factory.newExtensionElement(this.qn("logRecord"));
        Element e = erec.addExtension(this.qn("eventTimestamp"));
        e.setText(this.toAtomDateFormat(record.getDate()));
        e = erec.addExtension(this.qn("level"));
        e.setText(record.getLevel().toString());
        e = erec.addExtension(this.qn("loggerName"));
        e.setText(record.getLoggerName());
        e = erec.addExtension(this.qn("message"));
        e.setText(record.getMessage());
        e = erec.addExtension(this.qn("threadName"));
        e.setText(record.getThreadName());
        e = erec.addExtension(this.qn("throwable"));
        e.setText(record.getThrowable());
        return erec;
    }

    private String toAtomDateFormat(Date d) {
        String date = this.df.format(d);
        return date.substring(0, date.length() - 2) + ":" + date.substring(date.length() - 2);
    }

    private QName qn(String name) {
        return new QName("http://cxf.apache.org/log", name, "log");
    }

    private ExtensibleElement createExtension(List<LogRecord> records) {
        ExtensibleElement list = (ExtensibleElement)this.factory.newExtensionElement(this.qn("logRecords"));
        for (LogRecord rec : records) {
            list.addExtension((Element)this.createExtension(rec));
        }
        return list;
    }

    private Entry createEntry(List<LogRecord> records, int entryIndex) {
        Entry entry = this.factory.newEntry();
        this.setDefaultEntryProperties(entry, records, entryIndex);
        return entry;
    }

    private void setEntryContent(Entry e, String content) {
        e.setContent(content, Content.Type.XML);
    }

    private void setEntryContent(Entry e, ExtensibleElement ext) {
        e.addExtension((Element)ext);
    }

    private Feed createFeedWithSingleEntry(Format format, List<LogRecord> records) {
        Feed feed = this.factory.newFeed();
        feed.addEntry(this.createEntryFromList(format, records));
        this.setDefaultFeedProperties(feed, records);
        return feed;
    }

    private Feed createFeed(Format format, List<LogRecord> records) {
        Feed feed = this.factory.newFeed();
        List<Entry> entries = this.createEntries(format, records);
        for (Entry entry : entries) {
            feed.addEntry(entry);
        }
        this.setDefaultFeedProperties(feed, records);
        return feed;
    }

    protected void setDefaultFeedProperties(Feed feed, List<LogRecord> records) {
        if (this.feedBuilder != null) {
            Map links;
            feed.setId(this.feedBuilder.getId(records));
            feed.addAuthor(this.feedBuilder.getAuthor(records));
            feed.setTitle(this.feedBuilder.getTitle(records));
            feed.setUpdated(this.feedBuilder.getUpdated(records));
            feed.setBaseUri(this.feedBuilder.getBaseUri(records));
            List categories = this.feedBuilder.getCategories(records);
            if (categories != null) {
                for (String category : categories) {
                    feed.addCategory(category);
                }
            }
            if ((links = this.feedBuilder.getLinks(records)) != null) {
                for (Map.Entry mapEntry : links.entrySet()) {
                    feed.addLink((String)mapEntry.getKey(), (String)mapEntry.getValue());
                }
            }
        } else {
            feed.setId("uuid:" + UUID.randomUUID().toString());
            feed.addAuthor("CXF");
            feed.setTitle("CXF Service Log Entries");
            feed.setUpdated(new Date());
        }
    }

    protected void setDefaultEntryProperties(Entry entry, List<LogRecord> records, int entryIndex) {
        if (this.entryBuilder != null) {
            Map links;
            entry.setId(this.entryBuilder.getId(records));
            entry.addAuthor(this.entryBuilder.getAuthor(records));
            entry.setTitle(this.entryBuilder.getTitle(records));
            entry.setUpdated(this.entryBuilder.getUpdated(records));
            entry.setBaseUri(this.entryBuilder.getBaseUri(records));
            entry.setSummary(this.entryBuilder.getSummary(records));
            List categories = this.entryBuilder.getCategories(records);
            if (categories != null) {
                for (String category : categories) {
                    entry.addCategory(category);
                }
            }
            if ((links = this.entryBuilder.getLinks(records)) != null) {
                for (Map.Entry mapEntry : links.entrySet()) {
                    entry.addLink((String)mapEntry.getKey(), (String)mapEntry.getValue());
                }
            }
            entry.setPublished(this.entryBuilder.getPublished(records));
            entry.setSummary(this.entryBuilder.getSummary(records));
        } else {
            entry.addAuthor("CXF");
            if (records.size() != 1) {
                entry.setId("uuid:" + UUID.randomUUID().toString());
                entry.setTitle(String.format("Entry with %d log record(s)", records.size()));
            } else {
                entry.setId(records.get(0).getId());
                entry.setTitle("Log record with level " + records.get(0).getLevel().toString());
                entry.setSummary(records.get(0).getLoggerName() + " : " + records.get(0).getMessage());
            }
            if (records.size() > 0) {
                entry.setUpdated(this.toAtomDateFormat(records.get(0).getDate()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        CONTENT,
        EXTENSION;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Multiplicity {
        ONE,
        MANY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Output {
        FEED,
        ENTRY;

    }
}

