/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.browser.client.ui;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.inject.Inject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.cxf.management.web.browser.client.ui.resources.LogBrowserConstans;
import org.apache.cxf.management.web.browser.client.ui.resources.LogBrowserResources;

public class ErrorDialog
extends PopupPanel {
    @Nonnull
    private final LogBrowserResources resources;
    @Nonnull
    private final LogBrowserConstans contants;
    @Nonnull
    private final Button closeButton;

    @Inject
    protected ErrorDialog(@Nonnull LogBrowserResources resources, @Nonnull LogBrowserConstans contants) {
        super(false, true);
        this.resources = resources;
        this.contants = contants;
        this.closeButton = new Button();
    }

    public void setException(@Nonnull Throwable exception) {
        String errorClassName = exception.getClass().getName();
        if (errorClassName.startsWith("java.lang.")) {
            errorClassName = errorClassName.substring("java.lang.".length());
        } else if (errorClassName.startsWith("org.apache.cxf.")) {
            errorClassName = errorClassName.substring(errorClassName.lastIndexOf(46) + 1);
        }
        if (errorClassName.endsWith("Exception")) {
            errorClassName = errorClassName.substring(0, errorClassName.length() - "Exception".length());
        } else if (errorClassName.endsWith("Error")) {
            errorClassName = errorClassName.substring(0, errorClassName.length() - "Error".length());
        }
        this.initializeLayout(errorClassName, exception.getMessage());
    }

    public void center() {
        this.show();
        this.closeButton.setFocus(true);
    }

    private void initializeLayout(@Nonnull String errorName, @Nullable String errorMessage) {
        Label errorNameLabel = new Label(errorName);
        errorNameLabel.setStyleName(this.resources.css().errorDialogErrorType());
        Label errorMessageLabel = null;
        if (errorMessage != null && !"".equals(errorMessage)) {
            errorMessageLabel = new Label(errorMessage);
            DOM.setStyleAttribute((Element)errorMessageLabel.getElement(), (String)"whiteSpace", (String)"pre");
        }
        this.closeButton.setText(this.contants.errorDialogContineButton());
        this.closeButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ErrorDialog.this.hide();
            }
        });
        this.closeButton.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                event.stopPropagation();
            }
        });
        Label titleLabel = new Label();
        titleLabel.setStyleName(this.resources.css().errorDialogTitle());
        titleLabel.setText(this.contants.errorDialogTitle());
        FlowPanel contentPanel = new FlowPanel();
        contentPanel.add((Widget)errorNameLabel);
        contentPanel.add((Widget)errorMessageLabel);
        FlowPanel buttonsPanel = new FlowPanel();
        buttonsPanel.setStyleName(this.resources.css().errorDialogButtons());
        buttonsPanel.add((Widget)this.closeButton);
        FlowPanel centerPanel = new FlowPanel();
        centerPanel.add((Widget)titleLabel);
        centerPanel.add((Widget)contentPanel);
        centerPanel.add((Widget)buttonsPanel);
        this.setGlassEnabled(true);
        this.getGlassElement().addClassName(this.resources.css().errorDialogGlass());
        this.addStyleName(this.resources.css().errorDialog());
        this.add((Widget)centerPanel);
        int left = Window.getScrollLeft() + 20;
        int top = Window.getScrollTop() + 20;
        this.setPopupPosition(left, top);
    }
}

