/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.browser.client.ui.browser;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.cxf.management.web.browser.client.service.browser.Entry;
import org.apache.cxf.management.web.browser.client.service.browser.Links;
import org.apache.cxf.management.web.browser.client.ui.browser.EntryTable;
import org.apache.cxf.management.web.browser.client.ui.browser.SelectableTable;
import org.apache.cxf.management.web.browser.client.ui.browser.ViewerView;
import org.apache.cxf.management.web.browser.client.ui.resources.LogBrowserConstans;

@Singleton
public class ViewerViewImpl
extends Composite
implements ViewerView {
    private static final DateTimeFormat DT_FORMATTER = DateTimeFormat.getFormat((String)"HH:mm:ss dd.MM.yyyy");
    private static final ViewerViewUiBinder UI_BINDER = (ViewerViewUiBinder)GWT.create(ViewerViewUiBinder.class);
    @UiField
    @Nonnull
    EntryTable entryTable;
    @UiField
    @Nonnull
    HTML entryDetails;
    @UiField
    @Nonnull
    Anchor refreshButton;
    @UiField
    @Nonnull
    Anchor newerButton;
    @UiField
    @Nonnull
    Anchor olderButton;
    @UiField
    @Nonnull
    Anchor lastButton;
    @UiField
    @Nonnull
    Anchor firstButton;
    private ViewerView.Presenter presenter;
    @Nonnull
    private final LogBrowserConstans constans;

    @Inject
    public ViewerViewImpl(@Nonnull LogBrowserConstans constans) {
        this.constans = constans;
        this.initWidget((Widget)UI_BINDER.createAndBindUi(this));
        this.initEntryTable();
    }

    @Override
    public void setEntries(@Nonnull List<Entry> entries) {
        this.entryTable.setData(entries);
    }

    @Override
    public void setMessageInsteadOfEntries(@Nonnull String message, @Nullable String styleName) {
        this.entryTable.setMessageInsteadOfData(message, styleName);
    }

    @Override
    public void setEntryDetails(@Nullable Entry entry) {
        if (entry == null) {
            this.entryDetails.setHTML("");
            return;
        }
        String val = entry.getMessage() != null ? entry.getMessage() : (entry.getThrowable() != null ? entry.getThrowable() : "");
        this.entryDetails.setHTML(SafeHtmlUtils.fromString((String)val));
    }

    @Override
    public void setLinks(@Nonnull Links links) {
        this.olderButton.setVisible(links.previousAvailable());
        this.newerButton.setVisible(links.nextAvailable());
        this.refreshButton.setVisible(links.selfAvailable());
        this.lastButton.setVisible(links.lastAvailable());
        this.firstButton.setVisible(links.firstAvailable());
    }

    @UiHandler(value={"firstButton"})
    void onFirstButtonClicked(@Nonnull ClickEvent event) {
        assert (this.presenter != null);
        this.presenter.onFirstButtonClicked();
    }

    @UiHandler(value={"newerButton"})
    void onNewerButtonClicked(@Nonnull ClickEvent event) {
        assert (this.presenter != null);
        this.presenter.onNewerButtonClicked();
    }

    @UiHandler(value={"refreshButton"})
    void onRefreshButtonClicked(@Nonnull ClickEvent event) {
        assert (this.presenter != null);
        this.presenter.onRefreshButtonClicked();
    }

    @UiHandler(value={"olderButton"})
    void onOlderButtonClicked(@Nonnull ClickEvent event) {
        assert (this.presenter != null);
        this.presenter.onOlderButtonClicked();
    }

    @UiHandler(value={"lastButton"})
    void onLastButtonClicked(@Nonnull ClickEvent event) {
        assert (this.presenter != null);
        this.presenter.onLastButtonClicked();
    }

    private void initEntryTable() {
        this.entryTable.setColumnDefinitions(new SelectableTable.ColumnDefinition<Entry>(){

            @Override
            public String getContent(Entry entry) {
                return DT_FORMATTER.format(entry.getEventTimestamp());
            }

            @Override
            public String getWidth() {
                return ViewerViewImpl.this.constans.browseTabDatatimeColumnWidth();
            }
        }, new SelectableTable.ColumnDefinition<Entry>(){

            @Override
            public String getContent(Entry entry) {
                return entry.getLevel();
            }

            @Override
            public String getWidth() {
                return ViewerViewImpl.this.constans.browseTabLevelColumnWidth();
            }
        }, new SelectableTable.ColumnDefinition<Entry>(){

            @Override
            public String getContent(Entry entry) {
                return entry.getTitle();
            }

            @Override
            public String getWidth() {
                return null;
            }
        });
        this.entryTable.addSelectRowHandler(new SelectableTable.SelectRowHandler(){

            @Override
            public void onSelectRow(int row) {
                assert (ViewerViewImpl.this.presenter != null);
                ViewerViewImpl.this.presenter.onEntryItemClicked(row);
            }
        });
    }

    @Override
    public void setPresenter(ViewerView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public Widget asWidget() {
        return this;
    }

    @UiTemplate(value="ViewerView.ui.xml")
    static interface ViewerViewUiBinder
    extends UiBinder<Widget, ViewerViewImpl> {
    }
}

