/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.xml;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rs.security.common.CryptoLoader;
import org.apache.cxf.rs.security.common.SecurityUtils;
import org.apache.cxf.rs.security.xml.AbstractXmlSecOutInterceptor;
import org.apache.cxf.rs.security.xml.EncryptionProperties;
import org.apache.cxf.rs.security.xml.EncryptionUtils;
import org.apache.cxf.rs.security.xml.XmlSigOutInterceptor;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.message.token.DOMX509Data;
import org.apache.wss4j.dom.message.token.DOMX509IssuerSerial;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.stax.impl.util.IDGenerator;
import org.apache.xml.security.utils.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlEncOutInterceptor
extends AbstractXmlSecOutInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(XmlEncOutInterceptor.class);
    private static final String DEFAULT_RETRIEVAL_METHOD_TYPE = "http://www.w3.org/2001/04/xmlenc#EncryptedKey";
    private boolean encryptSymmetricKey = true;
    private SecretKey symmetricKey;
    private EncryptionProperties encProps = new EncryptionProperties();

    public XmlEncOutInterceptor() {
        this.addAfter(XmlSigOutInterceptor.class.getName());
    }

    public void setEncryptionProperties(EncryptionProperties props) {
        this.encProps = props;
    }

    public void setKeyIdentifierType(String type) {
        this.encProps.setEncryptionKeyIdType(type);
    }

    public void setSymmetricEncAlgorithm(String algo) {
        if (!algo.startsWith("http://www.w3.org/2001/04/xmlenc#") && !algo.startsWith("http://www.w3.org/2009/xmlenc11#")) {
            algo = "http://www.w3.org/2001/04/xmlenc#" + algo;
        }
        this.encProps.setEncryptionSymmetricKeyAlgo(algo);
    }

    public void setKeyEncAlgorithm(String algo) {
        this.encProps.setEncryptionKeyTransportAlgo(algo);
    }

    public void setDigestAlgorithm(String algo) {
        this.encProps.setEncryptionDigestAlgo(algo);
    }

    @Override
    protected Document processDocument(Message message, Document payloadDoc) throws Exception {
        return this.encryptDocument(message, payloadDoc);
    }

    protected Document encryptDocument(Message message, Document payloadDoc) throws Exception {
        XMLCipher xmlCipher;
        Document result;
        NodeList list;
        String symEncAlgo = this.encProps.getEncryptionSymmetricKeyAlgo() == null ? "http://www.w3.org/2001/04/xmlenc#aes256-cbc" : this.encProps.getEncryptionSymmetricKeyAlgo();
        byte[] secretKey = this.getSymmetricKey(symEncAlgo);
        Document encryptedDataDoc = DOMUtils.createDocument();
        Element encryptedDataElement = this.createEncryptedDataElement(encryptedDataDoc, symEncAlgo);
        if (this.encryptSymmetricKey) {
            X509Certificate receiverCert = null;
            String userName = (String)message.getContextualProperty("ws-security.encryption.username");
            if ("useReqSigCert".equals(userName) && !MessageUtils.isRequestor((Message)message)) {
                XMLSignature sig = (XMLSignature)message.getExchange().getInMessage().getContent(XMLSignature.class);
                if (sig != null) {
                    receiverCert = sig.getKeyInfo().getX509Certificate();
                }
            } else {
                CryptoLoader loader = new CryptoLoader();
                Crypto crypto = loader.getCrypto(message, "ws-security.encryption.crypto", "ws-security.encryption.properties");
                userName = SecurityUtils.getUserName(crypto, userName);
                if (StringUtils.isEmpty((String)userName)) {
                    throw new Exception("User name is not available");
                }
                receiverCert = this.getReceiverCertificateFromCrypto(crypto, userName);
            }
            if (receiverCert == null) {
                throw new Exception("Receiver certificate is not available");
            }
            String keyEncAlgo = this.encProps.getEncryptionKeyTransportAlgo() == null ? "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p" : this.encProps.getEncryptionKeyTransportAlgo();
            String digestAlgo = this.encProps.getEncryptionDigestAlgo();
            byte[] encryptedSecretKey = this.encryptSymmetricKey(secretKey, receiverCert, keyEncAlgo, digestAlgo);
            this.addEncryptedKeyElement(encryptedDataElement, receiverCert, encryptedSecretKey, keyEncAlgo, digestAlgo);
        }
        if ((list = (result = (xmlCipher = EncryptionUtils.initXMLCipher(symEncAlgo, 1, this.symmetricKey)).doFinal(payloadDoc, payloadDoc.getDocumentElement(), false)).getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue")).getLength() != 1) {
            throw new Exception("Payload CipherData is missing");
        }
        String cipherText = ((Element)list.item(0)).getTextContent().trim();
        Element cipherValue = this.createCipherValue(encryptedDataDoc, encryptedDataDoc.getDocumentElement());
        cipherValue.appendChild(encryptedDataDoc.createTextNode(cipherText));
        return encryptedDataDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getSymmetricKey(String symEncAlgo) throws Exception {
        XmlEncOutInterceptor xmlEncOutInterceptor = this;
        synchronized (xmlEncOutInterceptor) {
            if (this.symmetricKey == null) {
                KeyGenerator keyGen = this.getKeyGenerator(symEncAlgo);
                this.symmetricKey = keyGen.generateKey();
            }
            return this.symmetricKey.getEncoded();
        }
    }

    private X509Certificate getReceiverCertificateFromCrypto(Crypto crypto, String user) throws Exception {
        X509Certificate[] certs = SecurityUtils.getCertificates(crypto, user);
        return certs[0];
    }

    private KeyGenerator getKeyGenerator(String symEncAlgo) throws WSSecurityException {
        try {
            String keyAlgorithm = JCEMapper.getJCEKeyAlgorithmFromURI((String)symEncAlgo);
            KeyGenerator keyGen = KeyGenerator.getInstance(keyAlgorithm);
            if (symEncAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || symEncAlgo.equalsIgnoreCase("http://www.w3.org/2009/xmlenc11#aes128-gcm")) {
                keyGen.init(128);
            } else if (symEncAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes192-cbc") || symEncAlgo.equalsIgnoreCase("http://www.w3.org/2009/xmlenc11#aes192-gcm")) {
                keyGen.init(192);
            } else if (symEncAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes256-cbc") || symEncAlgo.equalsIgnoreCase("http://www.w3.org/2009/xmlenc11#aes256-gcm")) {
                keyGen.init(256);
            }
            return keyGen;
        }
        catch (NoSuchAlgorithmException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, (Exception)e);
        }
    }

    protected byte[] encryptSymmetricKey(byte[] keyBytes, X509Certificate remoteCert, String keyEncAlgo, String digestAlgo) throws WSSecurityException {
        Cipher cipher = EncryptionUtils.initCipherWithCert(keyEncAlgo, digestAlgo, 1, remoteCert);
        int blockSize = cipher.getBlockSize();
        if (blockSize > 0 && blockSize < keyBytes.length) {
            String message = "Public key algorithm too weak to encrypt symmetric key";
            LOG.severe(message);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "unsupportedKeyTransp", new Object[]{message});
        }
        byte[] encryptedEphemeralKey = null;
        try {
            encryptedEphemeralKey = cipher.doFinal(keyBytes);
        }
        catch (IllegalStateException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_ENCRYPTION, (Exception)ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_ENCRYPTION, (Exception)ex);
        }
        catch (BadPaddingException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_ENCRYPTION, (Exception)ex);
        }
        return encryptedEphemeralKey;
    }

    private void addEncryptedKeyElement(Element encryptedDataElement, X509Certificate cert, byte[] encryptedKey, String keyEncAlgo, String digestAlgo) throws Exception {
        Document doc = encryptedDataElement.getOwnerDocument();
        String encodedKey = Base64Utility.encode((byte[])encryptedKey);
        Element encryptedKeyElement = this.createEncryptedKeyElement(doc, keyEncAlgo, digestAlgo);
        String encKeyId = IDGenerator.generateID((String)"EK-");
        encryptedKeyElement.setAttributeNS(null, "Id", encKeyId);
        Element keyInfoElement = this.createKeyInfoElement(doc, cert);
        encryptedKeyElement.appendChild(keyInfoElement);
        Element xencCipherValue = this.createCipherValue(doc, encryptedKeyElement);
        xencCipherValue.appendChild(doc.createTextNode(encodedKey));
        Element topKeyInfoElement = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo");
        Element retrievalMethodElement = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:RetrievalMethod");
        retrievalMethodElement.setAttribute("Type", DEFAULT_RETRIEVAL_METHOD_TYPE);
        topKeyInfoElement.appendChild(retrievalMethodElement);
        topKeyInfoElement.appendChild(encryptedKeyElement);
        encryptedDataElement.appendChild(topKeyInfoElement);
    }

    protected Element createCipherValue(Document doc, Element encryptedKey) {
        Element cipherData = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:CipherData");
        Element cipherValue = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:CipherValue");
        cipherData.appendChild(cipherValue);
        encryptedKey.appendChild(cipherData);
        return cipherValue;
    }

    private Element createKeyInfoElement(Document encryptedDataDoc, X509Certificate remoteCert) throws Exception {
        Element keyInfoElement = encryptedDataDoc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo");
        String keyIdType = this.encProps.getEncryptionKeyIdType() == null ? "X509Certificate" : this.encProps.getEncryptionKeyIdType();
        Element keyIdentifierNode = null;
        if (keyIdType.equals("X509Certificate")) {
            byte[] data = null;
            try {
                data = remoteCert.getEncoded();
            }
            catch (CertificateEncodingException e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.SECURITY_TOKEN_UNAVAILABLE, (Exception)e, "encodeError");
            }
            Text text = encryptedDataDoc.createTextNode(Base64.encode((byte[])data));
            Element cert = encryptedDataDoc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509Certificate");
            cert.appendChild(text);
            Element x509Data = encryptedDataDoc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509Data");
            x509Data.appendChild(cert);
            keyIdentifierNode = x509Data;
        } else if (keyIdType.equals("X509IssuerSerial")) {
            String issuer = remoteCert.getIssuerDN().getName();
            BigInteger serialNumber = remoteCert.getSerialNumber();
            DOMX509IssuerSerial domIssuerSerial = new DOMX509IssuerSerial(encryptedDataDoc, issuer, serialNumber);
            DOMX509Data domX509Data = new DOMX509Data(encryptedDataDoc, domIssuerSerial);
            keyIdentifierNode = domX509Data.getElement();
        } else {
            throw new Exception("Unsupported key identifier:" + keyIdType);
        }
        keyInfoElement.appendChild(keyIdentifierNode);
        return keyInfoElement;
    }

    protected Element createEncryptedKeyElement(Document encryptedDataDoc, String keyEncAlgo, String digestAlgo) {
        Element encryptedKey = encryptedDataDoc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:EncryptedKey");
        Element encryptionMethod = encryptedDataDoc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:EncryptionMethod");
        encryptionMethod.setAttributeNS(null, "Algorithm", keyEncAlgo);
        if (digestAlgo != null) {
            Element digestMethod = encryptedDataDoc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestMethod");
            digestMethod.setAttributeNS(null, "Algorithm", digestAlgo);
            encryptionMethod.appendChild(digestMethod);
        }
        encryptedKey.appendChild(encryptionMethod);
        return encryptedKey;
    }

    protected Element createEncryptedDataElement(Document encryptedDataDoc, String symEncAlgo) {
        Element encryptedData = encryptedDataDoc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:EncryptedData");
        WSSecurityUtil.setNamespace((Element)encryptedData, (String)"http://www.w3.org/2001/04/xmlenc#", (String)"xenc");
        Element encryptionMethod = encryptedDataDoc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:EncryptionMethod");
        encryptionMethod.setAttributeNS(null, "Algorithm", symEncAlgo);
        encryptedData.appendChild(encryptionMethod);
        encryptedDataDoc.appendChild(encryptedData);
        return encryptedData;
    }
}

