/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.sse.atmosphere;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.sse.SseEventSink;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.sse.OutboundSseEventBodyWriter;
import org.apache.cxf.jaxrs.sse.atmosphere.SseAtmosphereEventSinkImpl;
import org.apache.cxf.message.Message;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;

public class SseAtmosphereEventSinkContextProvider
implements ContextProvider<SseEventSink> {
    public SseEventSink createContext(Message message) {
        HttpServletRequest request = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        if (request == null) {
            throw new IllegalStateException("Unable to retrieve HTTP request from the context");
        }
        AtmosphereResource resource = (AtmosphereResource)request.getAttribute(AtmosphereResource.class.getName());
        if (resource == null) {
            throw new IllegalStateException("AtmosphereResource is not present, is AtmosphereServlet configured properly?");
        }
        Broadcaster broadcaster = resource.getAtmosphereConfig().getBroadcasterFactory().lookup((Object)resource.uuid(), true);
        resource.removeFromAllBroadcasters();
        resource.setBroadcaster(broadcaster);
        OutboundSseEventBodyWriter writer = new OutboundSseEventBodyWriter(ServerProviderFactory.getInstance((Message)message), message.getExchange());
        return new SseAtmosphereEventSinkImpl(writer, resource);
    }
}

