/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.sse.atmosphere;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.SseEventSink;
import org.apache.cxf.common.logging.LogUtils;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.Broadcaster;

public class SseAtmosphereEventSinkImpl
implements SseEventSink {
    private static final Logger LOG = LogUtils.getL7dLogger(SseAtmosphereEventSinkImpl.class);
    private final AtmosphereResource resource;
    private final MessageBodyWriter<OutboundSseEvent> writer;
    private final boolean usingStream;
    private volatile boolean closed;

    public SseAtmosphereEventSinkImpl(MessageBodyWriter<OutboundSseEvent> writer, AtmosphereResource resource) {
        this.writer = writer;
        this.resource = resource;
        this.usingStream = (Boolean)resource.getRequest().getAttribute("org.atmosphere.useStream");
        if (!resource.isSuspended()) {
            LOG.fine("Atmosphere resource is not suspended, suspending");
            resource.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block12: {
            if (!this.closed) {
                this.closed = true;
                LOG.fine("Closing Atmosphere SSE event output");
                if (this.resource.isSuspended()) {
                    LOG.fine("Atmosphere resource is suspended, resuming");
                    this.resource.resume();
                }
                Broadcaster broadcaster = this.resource.getBroadcaster();
                this.resource.removeFromAllBroadcasters();
                try {
                    AtmosphereResponse response = this.resource.getResponse();
                    try {
                        if (this.usingStream) {
                            response.getOutputStream().close();
                            break block12;
                        }
                        response.getWriter().close();
                    }
                    catch (IOException ex) {
                        LOG.warning("Failed to flush AtmosphereResponse buffer: " + ex.getMessage());
                    }
                }
                finally {
                    try {
                        this.resource.close();
                    }
                    catch (IOException iOException) {}
                    broadcaster.destroy();
                    LOG.fine("Atmosphere SSE event output is closed");
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompletionStage<?> send(OutboundSseEvent event) {
        CompletableFuture future = new CompletableFuture();
        if (!this.closed && this.writer != null) {
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                this.writer.writeTo((Object)event, event.getClass(), null, new Annotation[0], event.getMediaType(), null, (OutputStream)os);
                CompletableFuture completableFuture = CompletableFuture.completedFuture(this.resource.getBroadcaster().broadcast((Object)os.toString(StandardCharsets.UTF_8.name())).get(1L, TimeUnit.SECONDS));
                return completableFuture;
            }
            catch (IOException ex) {
                LOG.warning("While writing the SSE event, an exception was raised: " + ex);
                future.completeExceptionally(ex);
                return future;
            }
            catch (InterruptedException | ExecutionException ex) {
                LOG.warning("SSE Atmosphere response was not delivered");
                future.completeExceptionally(ex);
                return future;
            }
            catch (TimeoutException ex) {
                LOG.warning("SSE Atmosphere response was not delivered within default timeout");
                future.completeExceptionally(ex);
                return future;
            }
        }
        future.complete(null);
        return future;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

