/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.addressing.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.ws.addressing.policy.MetadataConstants;
import org.apache.cxf.ws.policy.AssertionBuilder;
import org.apache.cxf.ws.policy.AssertionBuilderRegistry;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.policy.builder.primitive.NestedPrimitiveAssertion;
import org.apache.cxf.ws.policy.builder.primitive.NestedPrimitiveAssertionBuilder;
import org.apache.cxf.ws.policy.builder.primitive.PrimitiveAssertion;
import org.apache.cxf.ws.policy.builder.primitive.PrimitiveAssertionBuilder;
import org.apache.neethi.Assertion;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressingAssertionBuilder
implements AssertionBuilder {
    private static final Collection<QName> KNOWN = new ArrayList<QName>();
    private Bus bus;

    public AddressingAssertionBuilder(Bus b) {
        this.bus = b;
    }

    public Assertion build(Element elem) {
        String localName = elem.getLocalName();
        QName qn = new QName(elem.getNamespaceURI(), localName);
        boolean optional = false;
        PolicyConstants constants = (PolicyConstants)this.bus.getExtension(PolicyConstants.class);
        Attr attribute = elem.getAttributeNodeNS(constants.getNamespace(), constants.getOptionalAttrName());
        if (attribute != null) {
            optional = Boolean.valueOf(attribute.getValue());
        }
        if (MetadataConstants.ADDRESSING_ASSERTION_QNAME.equals(qn)) {
            PolicyBuilder builder = (PolicyBuilder)this.bus.getExtension(PolicyBuilder.class);
            return new NestedPrimitiveAssertion(elem, builder, constants);
        }
        if (MetadataConstants.ANON_RESPONSES_ASSERTION_QNAME.equals(qn)) {
            return new PrimitiveAssertion(MetadataConstants.ANON_RESPONSES_ASSERTION_QNAME, optional);
        }
        if (MetadataConstants.NON_ANON_RESPONSES_ASSERTION_QNAME.getLocalPart().equals(localName)) {
            return new PrimitiveAssertion(MetadataConstants.NON_ANON_RESPONSES_ASSERTION_QNAME, optional);
        }
        return null;
    }

    public Collection<QName> getKnownElements() {
        return KNOWN;
    }

    public Assertion buildCompatible(Assertion a, Assertion b) {
        QName qn = a.getName();
        if (MetadataConstants.ADDRESSING_ASSERTION_QNAME.equals(qn)) {
            NestedPrimitiveAssertionBuilder npab = new NestedPrimitiveAssertionBuilder();
            npab.setKnownElements(Collections.singleton(MetadataConstants.ADDRESSING_ASSERTION_QNAME));
            npab.setAssertionBuilderRegistry((AssertionBuilderRegistry)this.bus.getExtension(AssertionBuilderRegistry.class));
            return npab.buildCompatible(a, b);
        }
        if (MetadataConstants.ANON_RESPONSES_ASSERTION_QNAME.equals(qn) || MetadataConstants.NON_ANON_RESPONSES_ASSERTION_QNAME.equals(qn)) {
            PrimitiveAssertionBuilder pab = new PrimitiveAssertionBuilder();
            pab.setKnownElements(Collections.singleton(qn));
            return pab.buildCompatible(a, b);
        }
        return null;
    }

    static {
        KNOWN.add(MetadataConstants.ADDRESSING_ASSERTION_QNAME);
        KNOWN.add(MetadataConstants.ANON_RESPONSES_ASSERTION_QNAME);
        KNOWN.add(MetadataConstants.NON_ANON_RESPONSES_ASSERTION_QNAME);
    }
}

