/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Layout;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.PKIPathSecurity;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutPolicyValidator {
    public boolean validatePolicy(AssertionInfoMap aim, Message message, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults) {
        Collection ais = (Collection)aim.get((Object)SP12Constants.LAYOUT);
        if (ais != null && !ais.isEmpty()) {
            this.parsePolicies(aim, ais, message, results, signedResults);
        }
        return true;
    }

    private void parsePolicies(AssertionInfoMap aim, Collection<AssertionInfo> ais, Message message, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults) {
        for (AssertionInfo ai : ais) {
            Layout layout = (Layout)ai.getAssertion();
            ai.setAsserted(true);
            if (this.validatePolicy(layout, results, signedResults)) continue;
            String error = "Layout does not match the requirements";
            ai.setNotAsserted(error);
        }
    }

    public boolean validatePolicy(Layout layout, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults) {
        boolean strict;
        boolean timestampFirst = layout.getValue() == SPConstants.Layout.LaxTsFirst;
        boolean timestampLast = layout.getValue() == SPConstants.Layout.LaxTsLast;
        boolean bl = strict = layout.getValue() == SPConstants.Layout.Strict;
        if (timestampFirst) {
            if (results.isEmpty()) {
                return false;
            }
            Integer firstAction = (Integer)results.get(results.size() - 1).get((Object)"action");
            if (firstAction != 32) {
                return false;
            }
        } else if (timestampLast) {
            if (results.isEmpty()) {
                return false;
            }
            Integer lastAction = (Integer)results.get(0).get((Object)"action");
            if (lastAction != 32) {
                return false;
            }
        } else if (!(!strict || this.validateStrictSignaturePlacement(results, signedResults) && this.validateStrictSignatureTokenPlacement(results) && this.checkSignatureIsSignedPlacement(signedResults))) {
            return false;
        }
        return true;
    }

    private boolean validateStrictSignaturePlacement(List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults) {
        for (WSSecurityEngineResult signedResult : signedResults) {
            List sl = CastUtils.cast((List)((List)signedResult.get((Object)"data-ref-uris")));
            if (sl == null) continue;
            block1: for (WSDataRef r : sl) {
                String[] nodes;
                String xpath = r.getXpath();
                if (xpath == null || (nodes = StringUtils.split((String)xpath, (String)"/")).length != 5) continue;
                Element protectedElement = r.getProtectedElement();
                boolean tokenFound = false;
                for (WSSecurityEngineResult result : results) {
                    Element resultElement = (Element)result.get((Object)"token-element");
                    if (resultElement == protectedElement) {
                        tokenFound = true;
                    }
                    if (tokenFound && result == signedResult) {
                        return false;
                    }
                    if (resultElement == null || result != signedResult) continue;
                    continue block1;
                }
            }
        }
        return true;
    }

    private boolean validateStrictSignatureTokenPlacement(List<WSSecurityEngineResult> results) {
        for (int i = 0; i < results.size(); ++i) {
            int correspondingIndex;
            WSSecurityEngineResult result = results.get(i);
            Integer actInt = (Integer)result.get((Object)"action");
            if (actInt != 2 || (correspondingIndex = this.findCorrespondingTokenIndex(result, results)) <= 0 || correspondingIndex >= i) continue;
            return false;
        }
        return true;
    }

    private boolean checkSignatureIsSignedPlacement(List<WSSecurityEngineResult> signedResults) {
        for (int i = 0; i < signedResults.size(); ++i) {
            WSSecurityEngineResult signedResult = signedResults.get(i);
            List sl = CastUtils.cast((List)((List)signedResult.get((Object)"data-ref-uris")));
            if (sl == null || sl.size() < 1) continue;
            block1: for (WSDataRef dataRef : sl) {
                QName signedQName = dataRef.getName();
                if (!WSSecurityEngine.SIGNATURE.equals(signedQName)) continue;
                Element protectedElement = dataRef.getProtectedElement();
                boolean endorsingSigFound = false;
                for (WSSecurityEngineResult result : signedResults) {
                    Element resultElement;
                    if (result == signedResult) {
                        endorsingSigFound = true;
                    }
                    if ((resultElement = (Element)result.get((Object)"token-element")) != protectedElement) continue;
                    if (endorsingSigFound) continue block1;
                    return false;
                }
            }
        }
        return true;
    }

    private int findCorrespondingTokenIndex(WSSecurityEngineResult signatureResult, List<WSSecurityEngineResult> results) {
        X509Certificate cert = (X509Certificate)signatureResult.get((Object)"x509-certificate");
        PublicKey publicKey = (PublicKey)signatureResult.get((Object)"public-key");
        for (int i = 0; i < results.size(); ++i) {
            WSSecurityEngineResult token = results.get(i);
            Integer actInt = (Integer)token.get((Object)"action");
            if (actInt == 2) continue;
            BinarySecurity binarySecurity = (BinarySecurity)token.get((Object)"binary-security-token");
            PublicKey foundPublicKey = (PublicKey)token.get((Object)"public-key");
            if (binarySecurity instanceof X509Security || binarySecurity instanceof PKIPathSecurity) {
                X509Certificate foundCert = (X509Certificate)token.get((Object)"x509-certificate");
                if (!foundCert.equals(cert)) continue;
                return i;
            }
            if (actInt == 16 || actInt == 8) {
                AssertionWrapper assertionWrapper = (AssertionWrapper)token.get((Object)"saml-assertion");
                SAMLKeyInfo samlKeyInfo = assertionWrapper.getSubjectKeyInfo();
                if (samlKeyInfo == null) continue;
                X509Certificate[] subjectCerts = samlKeyInfo.getCerts();
                PublicKey subjectPublicKey = samlKeyInfo.getPublicKey();
                if ((cert == null || subjectCerts == null || !cert.equals(subjectCerts[0])) && (subjectPublicKey == null || !subjectPublicKey.equals(publicKey))) continue;
                return i;
            }
            if (publicKey == null || !publicKey.equals(foundPublicKey)) continue;
            return i;
        }
        return -1;
    }
}

