/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.junit.concurrent;

import com.mycila.junit.concurrent.Concurrency;
import com.mycila.junit.concurrent.ConcurrentRunnerScheduler;
import org.junit.Test;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConcurrentJunitRunner
extends BlockJUnit4ClassRunner {
    public ConcurrentJunitRunner(Class<?> klass) throws InitializationError {
        super(klass);
        int nThreads = 0;
        if (klass.isAnnotationPresent(Concurrency.class)) {
            nThreads = Math.max(0, klass.getAnnotation(Concurrency.class).value());
        }
        if (nThreads == 0) {
            nThreads = new TestClass(klass).getAnnotatedMethods(Test.class).size();
        }
        if (nThreads == 0) {
            nThreads = Runtime.getRuntime().availableProcessors();
        }
        this.setScheduler(new ConcurrentRunnerScheduler(klass.getSimpleName(), Math.min(Runtime.getRuntime().availableProcessors(), nThreads), nThreads));
    }
}

