/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.junit.concurrent;

import com.mycila.junit.concurrent.Concurrency;
import com.mycila.junit.concurrent.ConcurrentException;
import com.mycila.junit.concurrent.ConcurrentRunnerScheduler;
import java.util.concurrent.CountDownLatch;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public final class ConcurrentRule
implements MethodRule {
    public Statement apply(final Statement statement, final FrameworkMethod frameworkMethod, final Object o) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Concurrency concurrency = (Concurrency)frameworkMethod.getAnnotation(Concurrency.class);
                if (concurrency == null) {
                    statement.evaluate();
                } else {
                    int nThreads = Math.max(0, concurrency.value());
                    if (nThreads == 0) {
                        nThreads = Runtime.getRuntime().availableProcessors();
                    }
                    ConcurrentRunnerScheduler scheduler = new ConcurrentRunnerScheduler(o.getClass().getSimpleName() + "." + frameworkMethod.getName(), nThreads, nThreads);
                    final CountDownLatch go = new CountDownLatch(1);
                    Runnable runnable = new Runnable(){

                        public void run() {
                            try {
                                go.await();
                                statement.evaluate();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                            catch (Throwable throwable) {
                                throw ConcurrentException.wrap(throwable);
                            }
                        }
                    };
                    for (int i = 0; i < nThreads; ++i) {
                        scheduler.schedule(runnable);
                    }
                    go.countDown();
                    try {
                        scheduler.finished();
                    }
                    catch (ConcurrentException e) {
                        throw e.unwrap();
                    }
                }
            }
        };
    }
}

