/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.junit.concurrent;

import com.mycila.junit.concurrent.Concurrency;
import com.mycila.junit.concurrent.ConcurrentJunitRunner;
import com.mycila.junit.concurrent.ConcurrentRunnerScheduler;
import java.util.Arrays;
import java.util.List;
import org.junit.internal.builders.AllDefaultPossibilitiesBuilder;
import org.junit.runner.Runner;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConcurrentSuite
extends Suite {
    public ConcurrentSuite(Class<?> klass) throws InitializationError {
        super(klass, (RunnerBuilder)new AllDefaultPossibilitiesBuilder(true){

            public Runner runnerForClass(Class<?> testClass) throws Throwable {
                List<RunnerBuilder> builders = Arrays.asList(new RunnerBuilder(){

                    public Runner runnerForClass(Class<?> testClass) throws Throwable {
                        Concurrency annotation = testClass.getAnnotation(Concurrency.class);
                        return annotation != null ? new ConcurrentJunitRunner(testClass) : null;
                    }
                }, this.ignoredBuilder(), this.annotatedBuilder(), this.suiteMethodBuilder(), this.junit3Builder(), this.junit4Builder());
                for (RunnerBuilder each : builders) {
                    Runner runner = each.safeRunnerForClass(testClass);
                    if (runner == null) continue;
                    return runner;
                }
                return null;
            }
        });
        int nThreads = 0;
        if (klass.isAnnotationPresent(Concurrency.class)) {
            nThreads = Math.max(0, klass.getAnnotation(Concurrency.class).value());
        }
        if (nThreads == 0) {
            Suite.SuiteClasses suiteClasses = klass.getAnnotation(Suite.SuiteClasses.class);
            nThreads = suiteClasses != null ? suiteClasses.value().length : Runtime.getRuntime().availableProcessors();
        }
        this.setScheduler(new ConcurrentRunnerScheduler(klass.getSimpleName(), Math.min(Runtime.getRuntime().availableProcessors(), nThreads), nThreads));
    }
}

