/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.junit.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.directory.junit.tools.NoMultiThreadedInvocation;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class MultiThreadedMultiInvoker
implements MethodRule {
    public static final boolean THREADSAFE = true;
    public static final boolean NOT_THREADSAFE = false;
    private static ExecutorService pool = Executors.newCachedThreadPool();
    private int numThreads;
    private int numInvocationsPerThread;
    private boolean trace;

    public MultiThreadedMultiInvoker(boolean threadSafe) {
        this.numThreads = threadSafe ? this.getSystemIntProperty("mtmi.threads", 1) : 1;
        this.numInvocationsPerThread = this.getSystemIntProperty("mtmi.invocations", 1);
        this.trace = this.getSystemBoolProperty("mtmi.trace", false);
    }

    private int getSystemIntProperty(String key, int def) {
        String property = System.getProperty(key, "" + def);
        int value = Integer.parseInt(property);
        return value;
    }

    private boolean getSystemBoolProperty(String key, boolean def) {
        String property = System.getProperty(key, "" + def);
        boolean value = Boolean.parseBoolean(property);
        return value;
    }

    public MultiThreadedMultiInvoker(int numThreads, int numInvocationsPerThread) {
        this.numThreads = numThreads;
        this.numInvocationsPerThread = numInvocationsPerThread;
        this.trace = false;
    }

    public MultiThreadedMultiInvoker(int numThreads, int numInvocationsPerThread, boolean trace) {
        this.numThreads = numThreads;
        this.numInvocationsPerThread = numInvocationsPerThread;
        this.trace = trace;
    }

    public Statement apply(final Statement base, final FrameworkMethod method, Object target) {
        final List throwables = Collections.synchronizedList(new ArrayList());
        final ArrayList runnables = new ArrayList();
        return new Statement(){

            public void evaluate() throws Throwable {
                int count = MultiThreadedMultiInvoker.this.numThreads;
                if (method.getAnnotation(NoMultiThreadedInvocation.class) != null) {
                    count = 1;
                }
                final long start = System.currentTimeMillis();
                final AtomicInteger counter = new AtomicInteger();
                for (int threadNum = 0; threadNum < count; ++threadNum) {
                    Runnable r = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                for (int invocationNum = 0; invocationNum < MultiThreadedMultiInvoker.this.numInvocationsPerThread; ++invocationNum) {
                                    if (MultiThreadedMultiInvoker.this.trace) {
                                        long t = System.currentTimeMillis() - start;
                                        System.out.println(t + " - " + method.getName() + " - " + Thread.currentThread().getName() + " - Invocation " + (invocationNum + 1) + "/" + MultiThreadedMultiInvoker.this.numInvocationsPerThread);
                                    }
                                    base.evaluate();
                                }
                            }
                            catch (Throwable t) {
                                if (MultiThreadedMultiInvoker.this.trace) {
                                    t.printStackTrace();
                                }
                                throwables.add(t);
                            }
                            finally {
                                counter.decrementAndGet();
                            }
                        }
                    };
                    runnables.add(r);
                    counter.incrementAndGet();
                }
                for (Runnable r : runnables) {
                    pool.execute(r);
                }
                while (counter.get() > 0) {
                    Thread.sleep(1000L);
                }
                if (!throwables.isEmpty()) {
                    throw (Throwable)throwables.get(0);
                }
            }
        };
    }
}

