/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common;

import java.util.Arrays;
import java.util.Collection;

public class AutoCloseables {
    public static AutoCloseable all(final Collection<? extends AutoCloseable> autoCloseables) {
        return new AutoCloseable(){

            @Override
            public void close() throws Exception {
                AutoCloseables.close(autoCloseables);
            }
        };
    }

    public static void close(Throwable t, AutoCloseable ... autoCloseables) {
        AutoCloseables.close(t, Arrays.asList(autoCloseables));
    }

    public static void close(Throwable t, Collection<? extends AutoCloseable> autoCloseables) {
        try {
            AutoCloseables.close(autoCloseables);
        }
        catch (Exception e) {
            t.addSuppressed(e);
        }
    }

    public static void close(AutoCloseable ... autoCloseables) throws Exception {
        AutoCloseables.close(Arrays.asList(autoCloseables));
    }

    public static void close(Iterable<? extends AutoCloseable> ac) throws Exception {
        Exception topLevelException = null;
        for (AutoCloseable autoCloseable : ac) {
            try {
                if (autoCloseable == null) continue;
                autoCloseable.close();
            }
            catch (Exception e) {
                if (topLevelException == null) {
                    topLevelException = e;
                    continue;
                }
                topLevelException.addSuppressed(e);
            }
        }
        if (topLevelException != null) {
            throw topLevelException;
        }
    }
}

