/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.pac4j;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import org.apache.druid.crypto.CryptoService;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.pac4j.core.context.ContextHelper;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.JavaSerializationHelper;

public class Pac4jSessionStore<T extends WebContext>
implements SessionStore<T> {
    private static final Logger LOGGER = new Logger(Pac4jSessionStore.class);
    public static final String PAC4J_SESSION_PREFIX = "pac4j.session.";
    private final JavaSerializationHelper javaSerializationHelper = new JavaSerializationHelper();
    private final CryptoService cryptoService;

    public Pac4jSessionStore(String cookiePassphrase) {
        this.cryptoService = new CryptoService(cookiePassphrase, "AES", "CBC", "PKCS5Padding", "PBKDF2WithHmacSHA256", Integer.valueOf(8), Integer.valueOf(65536), Integer.valueOf(128));
    }

    public String getOrCreateSessionId(WebContext context) {
        return null;
    }

    @Nullable
    public Object get(WebContext context, String key) {
        Cookie cookie = ContextHelper.getCookie((WebContext)context, (String)(PAC4J_SESSION_PREFIX + key));
        Serializable value = null;
        if (cookie != null) {
            value = this.uncompressDecryptBase64(cookie.getValue());
        }
        LOGGER.debug("Get from session: [%s] = [%s]", new Object[]{key, value});
        return value;
    }

    public void set(WebContext context, String key, @Nullable Object value) {
        Cookie cookie;
        Object profile = value;
        if (value == null) {
            cookie = new Cookie(PAC4J_SESSION_PREFIX + key, null);
        } else {
            if (key.contentEquals("pac4jUserProfiles")) {
                profile = this.clearUserProfile(value);
            }
            LOGGER.debug("Save in session: [%s] = [%s]", new Object[]{key, profile});
            cookie = new Cookie(PAC4J_SESSION_PREFIX + key, this.compressEncryptBase64(profile));
        }
        cookie.setDomain("");
        cookie.setHttpOnly(true);
        cookie.setSecure(ContextHelper.isHttpsOrSecure((WebContext)context));
        cookie.setPath("/");
        cookie.setMaxAge(900);
        context.addResponseCookie(cookie);
    }

    @Nullable
    private String compressEncryptBase64(Object o) {
        if (o == null || "".equals(o) || o instanceof Map && ((Map)o).isEmpty()) {
            return null;
        }
        byte[] bytes = this.javaSerializationHelper.serializeToBytes((Serializable)o);
        if ((bytes = this.compress(bytes)).length > 3000) {
            LOGGER.warn("Cookie too big, it might not be properly set", new Object[0]);
        }
        return StringUtils.encodeBase64String((byte[])this.cryptoService.encrypt(bytes));
    }

    @Nullable
    private Serializable uncompressDecryptBase64(String v) {
        byte[] bytes;
        if (v != null && !v.isEmpty() && (bytes = StringUtils.decodeBase64String((String)v)) != null) {
            return this.javaSerializationHelper.unserializeFromBytes(this.unCompress(this.cryptoService.decrypt(bytes)));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] compress(byte[] data) {
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream(data.length);){
            try (GZIPOutputStream gzip = new GZIPOutputStream(byteStream);){
                gzip.write(data);
            }
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new TechnicalException((Throwable)ex);
        }
    }

    /*
     * Exception decompiling
     */
    private byte[] unCompress(byte[] data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Object clearUserProfile(Object value) {
        if (value instanceof Map) {
            Map profiles = (Map)value;
            profiles.forEach((name, profile) -> profile.clearSensitiveData());
            return profiles;
        }
        CommonProfile profile2 = (CommonProfile)value;
        profile2.clearSensitiveData();
        return profile2;
    }

    public SessionStore buildFromTrackableSession(WebContext arg0, Object arg1) {
        return null;
    }

    public boolean destroySession(WebContext arg0) {
        return false;
    }

    public Object getTrackableSession(WebContext arg0) {
        return null;
    }

    public boolean renewSession(WebContext context) {
        return false;
    }
}

