/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.pac4j;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.druid.crypto.CryptoService;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.pac4j.core.context.ContextHelper;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.JavaSerializationHelper;

public class Pac4jSessionStore<T extends WebContext>
implements SessionStore<T> {
    private static final Logger LOGGER = new Logger(Pac4jSessionStore.class);
    public static final String PAC4J_SESSION_PREFIX = "pac4j.session.";
    private final JavaSerializationHelper javaSerializationHelper = new JavaSerializationHelper();
    private final CryptoService cryptoService;

    public Pac4jSessionStore(String cookiePassphrase) {
        this.cryptoService = new CryptoService(cookiePassphrase, "AES", "CBC", "PKCS5Padding", "PBKDF2WithHmacSHA256", Integer.valueOf(8), Integer.valueOf(65536), Integer.valueOf(128));
    }

    public String getOrCreateSessionId(WebContext context) {
        return null;
    }

    @Nullable
    public Optional<Object> get(WebContext context, String key) {
        Cookie cookie = ContextHelper.getCookie((WebContext)context, (String)(PAC4J_SESSION_PREFIX + key));
        Serializable value = null;
        if (cookie != null) {
            value = this.uncompressDecryptBase64(cookie.getValue());
        }
        LOGGER.debug("Get from session: [%s] = [%s]", new Object[]{key, value});
        return Optional.ofNullable(value);
    }

    public void set(WebContext context, String key, @Nullable Object value) {
        Cookie cookie;
        Object profile = value;
        if (value == null) {
            cookie = new Cookie(PAC4J_SESSION_PREFIX + key, null);
        } else {
            if (key.contentEquals("pac4jUserProfiles")) {
                profile = this.clearUserProfile(value);
            }
            LOGGER.debug("Save in session: [%s] = [%s]", new Object[]{key, profile});
            cookie = new Cookie(PAC4J_SESSION_PREFIX + key, this.compressEncryptBase64(profile));
        }
        cookie.setDomain("");
        cookie.setHttpOnly(true);
        cookie.setSecure(ContextHelper.isHttpsOrSecure((WebContext)context));
        cookie.setPath("/");
        cookie.setMaxAge(900);
        context.addResponseCookie(cookie);
    }

    @Nullable
    private String compressEncryptBase64(Object o) {
        if (o == null || "".equals(o) || o instanceof Map && ((Map)o).isEmpty()) {
            return null;
        }
        byte[] bytes = this.javaSerializationHelper.serializeToBytes((Serializable)o);
        if ((bytes = this.compress(bytes)).length > 3000) {
            LOGGER.warn("Cookie too big, it might not be properly set", new Object[0]);
        }
        return StringUtils.encodeBase64String((byte[])this.cryptoService.encrypt(bytes));
    }

    @Nullable
    private Serializable uncompressDecryptBase64(String v) {
        byte[] bytes;
        if (v != null && !v.isEmpty() && (bytes = StringUtils.decodeBase64String((String)v)) != null) {
            return this.javaSerializationHelper.deserializeFromBytes(this.unCompress(this.cryptoService.decrypt(bytes)));
        }
        return null;
    }

    private byte[] compress(byte[] data) {
        byte[] byArray;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(data.length);
        try {
            try (GZIPOutputStream gzip = new GZIPOutputStream(byteStream);){
                gzip.write(data);
            }
            byArray = byteStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new TechnicalException((Throwable)ex);
            }
        }
        byteStream.close();
        return byArray;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] unCompress(byte[] data) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(data);){
            byte[] byArray;
            try (GZIPInputStream gzip = new GZIPInputStream(inputStream);){
                byArray = IOUtils.toByteArray((InputStream)gzip);
            }
            return byArray;
        }
        catch (IOException ex) {
            throw new TechnicalException((Throwable)ex);
        }
    }

    private Object clearUserProfile(Object value) {
        if (value instanceof Map) {
            Map profiles = (Map)value;
            profiles.forEach((name, profile) -> profile.removeLoginData());
            return profiles;
        }
        CommonProfile profile2 = (CommonProfile)value;
        profile2.removeLoginData();
        return profile2;
    }

    public Optional<SessionStore<T>> buildFromTrackableSession(WebContext arg0, Object arg1) {
        return Optional.empty();
    }

    public boolean destroySession(WebContext arg0) {
        return false;
    }

    public Optional getTrackableSession(WebContext arg0) {
        return Optional.empty();
    }

    public boolean renewSession(WebContext context) {
        return false;
    }
}

