/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractServiceConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.annotation.Service;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ServiceMetadata;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.dubbo.rpc.support.ProtocolUtils;

public abstract class ServiceConfigBase<T>
extends AbstractServiceConfig {
    private static final long serialVersionUID = 3033787999037024738L;
    protected Class<?> interfaceClass;
    protected T ref;
    protected String path;
    protected ProviderConfig provider;
    protected String providerIds;
    protected volatile String generic;

    public ServiceConfigBase() {
        this.serviceMetadata = new ServiceMetadata();
        this.serviceMetadata.addAttribute("ORIGIN_CONFIG", this);
    }

    public ServiceConfigBase(Service service) {
        this.serviceMetadata = new ServiceMetadata();
        this.serviceMetadata.addAttribute("ORIGIN_CONFIG", this);
        this.appendAnnotation(Service.class, service);
        this.setMethods(MethodConfig.constructMethodConfig(service.methods()));
    }

    @Deprecated
    private static List<ProtocolConfig> convertProviderToProtocol(List<ProviderConfig> providers) {
        if (CollectionUtils.isEmpty(providers)) {
            return null;
        }
        ArrayList<ProtocolConfig> protocols = new ArrayList<ProtocolConfig>(providers.size());
        for (ProviderConfig provider : providers) {
            protocols.add(ServiceConfigBase.convertProviderToProtocol(provider));
        }
        return protocols;
    }

    @Deprecated
    private static List<ProviderConfig> convertProtocolToProvider(List<ProtocolConfig> protocols) {
        if (CollectionUtils.isEmpty(protocols)) {
            return null;
        }
        ArrayList<ProviderConfig> providers = new ArrayList<ProviderConfig>(protocols.size());
        for (ProtocolConfig provider : protocols) {
            providers.add(ServiceConfigBase.convertProtocolToProvider(provider));
        }
        return providers;
    }

    @Deprecated
    private static ProtocolConfig convertProviderToProtocol(ProviderConfig provider) {
        ProtocolConfig protocol = new ProtocolConfig();
        protocol.setName(provider.getProtocol().getName());
        protocol.setServer(provider.getServer());
        protocol.setClient(provider.getClient());
        protocol.setCodec(provider.getCodec());
        protocol.setHost(provider.getHost());
        protocol.setPort(provider.getPort());
        protocol.setPath(provider.getPath());
        protocol.setPayload(provider.getPayload());
        protocol.setThreads(provider.getThreads());
        protocol.setParameters(provider.getParameters());
        return protocol;
    }

    @Deprecated
    private static ProviderConfig convertProtocolToProvider(ProtocolConfig protocol) {
        ProviderConfig provider = new ProviderConfig();
        provider.setProtocol(protocol);
        provider.setServer(protocol.getServer());
        provider.setClient(protocol.getClient());
        provider.setCodec(protocol.getCodec());
        provider.setHost(protocol.getHost());
        provider.setPort(protocol.getPort());
        provider.setPath(protocol.getPath());
        provider.setPayload(protocol.getPayload());
        provider.setThreads(protocol.getThreads());
        provider.setParameters(protocol.getParameters());
        return provider;
    }

    public boolean shouldExport() {
        Boolean export = this.getExport();
        return export == null ? true : export;
    }

    @Override
    public Boolean getExport() {
        return this.export == null && this.provider != null ? this.provider.getExport() : this.export;
    }

    public boolean shouldDelay() {
        Integer delay = this.getDelay();
        return delay != null && delay > 0;
    }

    @Override
    public Integer getDelay() {
        return this.delay == null && this.provider != null ? this.provider.getDelay() : this.delay;
    }

    public void checkRef() {
        if (this.ref == null) {
            throw new IllegalStateException("ref not allow null!");
        }
        if (!this.interfaceClass.isInstance(this.ref)) {
            throw new IllegalStateException("The class " + this.ref.getClass().getName() + " unimplemented interface " + this.interfaceClass + "!");
        }
    }

    public Optional<String> getContextPath(ProtocolConfig protocolConfig) {
        String contextPath = protocolConfig.getContextpath();
        if (StringUtils.isEmpty(contextPath) && this.provider != null) {
            contextPath = this.provider.getContextpath();
        }
        return Optional.ofNullable(contextPath);
    }

    protected Class getServiceClass(T ref) {
        return ref.getClass();
    }

    public void checkDefault() throws IllegalStateException {
        if (this.provider == null) {
            this.provider = ApplicationModel.getConfigManager().getDefaultProvider().orElse(new ProviderConfig());
        }
    }

    public void checkProtocol() {
        if (this.provider != null && this.notHasSelfProtocolProperty()) {
            this.setProtocols(this.provider.getProtocols());
            this.setProtocolIds(this.provider.getProtocolIds());
        }
        if (CollectionUtils.isEmpty(this.protocols) && this.provider != null) {
            this.setProtocols(this.provider.getProtocols());
        }
        this.convertProtocolIdsToProtocols();
    }

    private boolean notHasSelfProtocolProperty() {
        return CollectionUtils.isEmpty(this.protocols) && StringUtils.isEmpty(this.protocolIds);
    }

    public void completeCompoundConfigs() {
        super.completeCompoundConfigs(this.provider);
        if (this.provider != null) {
            if (this.notHasSelfProtocolProperty()) {
                this.setProtocols(this.provider.getProtocols());
                this.setProtocolIds(this.provider.getProtocolIds());
            }
            if (this.configCenter == null) {
                this.setConfigCenter(this.provider.getConfigCenter());
            }
        }
    }

    private void convertProtocolIdsToProtocols() {
        if (StringUtils.isEmpty(this.protocolIds)) {
            if (CollectionUtils.isEmpty(this.protocols)) {
                List<ProtocolConfig> protocolConfigs = ApplicationModel.getConfigManager().getDefaultProtocols();
                if (protocolConfigs.isEmpty()) {
                    protocolConfigs = new ArrayList<ProtocolConfig>(1);
                    ProtocolConfig protocolConfig = new ProtocolConfig();
                    protocolConfig.setDefault(true);
                    protocolConfig.refresh();
                    protocolConfigs.add(protocolConfig);
                    ApplicationModel.getConfigManager().addProtocol(protocolConfig);
                }
                this.setProtocols(protocolConfigs);
            }
        } else {
            String[] arr = CommonConstants.COMMA_SPLIT_PATTERN.split(this.protocolIds);
            ArrayList tmpProtocols = new ArrayList();
            Arrays.stream(arr).forEach(id -> {
                if (tmpProtocols.stream().noneMatch(prot -> prot.getId().equals(id))) {
                    Optional<ProtocolConfig> globalProtocol = ApplicationModel.getConfigManager().getProtocol((String)id);
                    if (globalProtocol.isPresent()) {
                        tmpProtocols.add(globalProtocol.get());
                    } else {
                        ProtocolConfig protocolConfig = new ProtocolConfig();
                        protocolConfig.setId((String)id);
                        protocolConfig.refresh();
                        tmpProtocols.add(protocolConfig);
                    }
                }
            });
            if (tmpProtocols.size() > arr.length) {
                throw new IllegalStateException("Too much protocols found, the protocols comply to this service are :" + this.protocolIds + " but got " + this.protocols.size() + " registries!");
            }
            this.setProtocols(tmpProtocols);
        }
    }

    public Class<?> getInterfaceClass() {
        if (this.interfaceClass != null) {
            return this.interfaceClass;
        }
        if (this.ref instanceof GenericService) {
            return GenericService.class;
        }
        try {
            if (this.interfaceName != null && this.interfaceName.length() > 0) {
                this.interfaceClass = Class.forName(this.interfaceName, true, Thread.currentThread().getContextClassLoader());
            }
        }
        catch (ClassNotFoundException t) {
            throw new IllegalStateException(t.getMessage(), t);
        }
        return this.interfaceClass;
    }

    public void setInterfaceClass(Class<?> interfaceClass) {
        this.setInterface(interfaceClass);
    }

    public void setInterface(Class<?> interfaceClass) {
        if (interfaceClass != null && !interfaceClass.isInterface()) {
            throw new IllegalStateException("The interface class " + interfaceClass + " is not a interface!");
        }
        this.interfaceClass = interfaceClass;
        this.setInterface(interfaceClass == null ? null : interfaceClass.getName());
    }

    public T getRef() {
        return this.ref;
    }

    public void setRef(T ref) {
        this.ref = ref;
    }

    @Parameter(excluded=true)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ProviderConfig getProvider() {
        return this.provider;
    }

    public void setProvider(ProviderConfig provider) {
        ApplicationModel.getConfigManager().addProvider(provider);
        this.provider = provider;
    }

    @Parameter(excluded=true)
    public String getProviderIds() {
        return this.providerIds;
    }

    public void setProviderIds(String providerIds) {
        this.providerIds = providerIds;
    }

    public String getGeneric() {
        return this.generic;
    }

    public void setGeneric(String generic) {
        if (StringUtils.isEmpty(generic)) {
            return;
        }
        if (!ProtocolUtils.isValidGenericValue(generic)) {
            throw new IllegalArgumentException("Unsupported generic type " + generic);
        }
        this.generic = generic;
    }

    public ServiceMetadata getServiceMetadata() {
        return this.serviceMetadata;
    }

    @Deprecated
    public List<ProviderConfig> getProviders() {
        return ServiceConfigBase.convertProtocolToProvider(this.protocols);
    }

    @Deprecated
    public void setProviders(List<ProviderConfig> providers) {
        this.protocols = ServiceConfigBase.convertProviderToProtocol(providers);
    }

    @Override
    @Parameter(excluded=true)
    public String getPrefix() {
        return "dubbo.service." + this.interfaceName;
    }

    @Parameter(excluded=true)
    public String getUniqueServiceName() {
        return URL.buildKey(this.interfaceName, this.getGroup(), this.getVersion());
    }

    @Override
    public String getGroup() {
        return StringUtils.isEmpty(this.group) ? (this.provider != null ? this.provider.getGroup() : this.group) : this.group;
    }

    @Override
    public String getVersion() {
        return StringUtils.isEmpty(this.version) ? (this.provider != null ? this.provider.getVersion() : this.version) : this.version;
    }

    @Override
    protected void computeValidRegistryIds() {
        if (this.provider != null && this.notHasSelfRegistryProperty()) {
            this.setRegistries(this.provider.getRegistries());
            this.setRegistryIds(this.provider.getRegistryIds());
        }
        super.computeValidRegistryIds();
    }

    public abstract void export();

    public abstract void unexport();

    public abstract boolean isExported();

    public abstract boolean isUnexported();
}

