/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.convert;

import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.extension.SPI;
import org.apache.dubbo.common.lang.Prioritized;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.TypeUtils;

@SPI
@FunctionalInterface
public interface Converter<S, T>
extends Prioritized {
    default public boolean accept(Class<?> sourceType, Class<?> targetType) {
        return ClassUtils.isAssignableFrom(sourceType, this.getSourceType()) && ClassUtils.isAssignableFrom(targetType, this.getTargetType());
    }

    public T convert(S var1);

    default public Class<S> getSourceType() {
        return TypeUtils.findActualTypeArgument(this.getClass(), Converter.class, 0);
    }

    default public Class<T> getTargetType() {
        return TypeUtils.findActualTypeArgument(this.getClass(), Converter.class, 1);
    }

    public static Converter<?, ?> getConverter(Class<?> sourceType, Class<?> targetType) {
        return ExtensionLoader.getExtensionLoader(Converter.class).getSupportedExtensionInstances().stream().filter(converter -> converter.accept(sourceType, targetType)).findFirst().orElse(null);
    }

    public static <T> T convertIfPossible(Object source, Class<T> targetType) {
        Converter<?, ?> converter = Converter.getConverter(source.getClass(), targetType);
        if (converter != null) {
            return (T)converter.convert(source);
        }
        return null;
    }
}

