/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.url.component;

import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.url.component.PathURLAddress;
import org.apache.dubbo.common.url.component.URLAddress;
import org.apache.dubbo.common.url.component.URLParam;

public class ServiceConfigURL
extends URL {
    private final Map<String, Object> attributes;
    private volatile transient String full;
    private volatile transient String string;
    private volatile transient String identity;
    private volatile transient String parameter;

    public ServiceConfigURL() {
        this.attributes = null;
    }

    public ServiceConfigURL(URLAddress urlAddress, URLParam urlParam, Map<String, Object> attributes) {
        super(urlAddress, urlParam);
        this.attributes = attributes != null ? attributes : new HashMap();
    }

    public ServiceConfigURL(String protocol, String username, String password, String host, int port, String path, Map<String, String> parameters) {
        this(new PathURLAddress(protocol, username, password, path, host, port), new URLParam(parameters), null);
    }

    public ServiceConfigURL(String protocol, String username, String password, String host, int port, String path, Map<String, String> parameters, Map<String, Object> attributes) {
        this(new PathURLAddress(protocol, username, password, path, host, port), new URLParam(parameters), attributes);
    }

    @Override
    protected <T extends URL> T newURL(URLAddress urlAddress, URLParam urlParam) {
        return (T)new ServiceConfigURL(urlAddress, urlParam, this.attributes);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public URL addAttributes(Map<String, Object> attributes) {
        HashMap<String, Object> newAttributes = new HashMap<String, Object>();
        newAttributes.putAll(this.attributes);
        newAttributes.putAll(attributes);
        return new ServiceConfigURL(this.getUrlAddress(), this.getUrlParam(), newAttributes);
    }

    @Override
    public ServiceConfigURL putAttribute(String key, Object obj) {
        HashMap<String, Object> newAttributes = new HashMap<String, Object>(this.attributes);
        newAttributes.put(key, obj);
        return new ServiceConfigURL(this.getUrlAddress(), this.getUrlParam(), newAttributes);
    }

    @Override
    public URL removeAttribute(String key) {
        HashMap<String, Object> newAttributes = new HashMap<String, Object>(this.attributes);
        newAttributes.remove(key);
        return new ServiceConfigURL(this.getUrlAddress(), this.getUrlParam(), newAttributes);
    }

    @Override
    public boolean hasAttribute(String key) {
        return this.getAttribute(key) != null;
    }

    @Override
    public String toString() {
        if (this.string != null) {
            return this.string;
        }
        this.string = super.toString();
        return this.string;
    }

    @Override
    public String toFullString() {
        if (this.full != null) {
            return this.full;
        }
        this.full = super.toFullString();
        return this.full;
    }

    @Override
    public String toIdentityString() {
        if (this.identity != null) {
            return this.identity;
        }
        this.identity = super.toIdentityString();
        return this.identity;
    }

    @Override
    public String toParameterString() {
        if (this.parameter != null) {
            return this.parameter;
        }
        this.parameter = super.toParameterString();
        return this.parameter;
    }
}

