/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.url.component;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLStrParser;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;

public class URLParam
implements Serializable {
    private static final long serialVersionUID = -1985165475234910535L;
    private final String rawParam;
    private final Map<String, String> params;
    private transient Map<String, Map<String, String>> methodParameters;
    private transient long timestamp;

    public URLParam(Map<String, String> params) {
        this(params, null);
    }

    public URLParam(Map<String, String> params, String rawParam) {
        this.params = Collections.unmodifiableMap(params == null ? new HashMap() : new HashMap<String, String>(params));
        this.rawParam = rawParam;
        this.timestamp = System.currentTimeMillis();
    }

    public Map<String, Map<String, String>> getMethodParameters() {
        if (this.methodParameters == null) {
            this.methodParameters = Collections.unmodifiableMap(URLParam.initMethodParameters(this.params));
        }
        return this.methodParameters;
    }

    public static Map<String, Map<String, String>> initMethodParameters(Map<String, String> parameters) {
        HashMap<String, Map<String, String>> methodParameters = new HashMap<String, Map<String, String>>();
        if (parameters == null) {
            return methodParameters;
        }
        String methodsString = parameters.get("methods");
        if (StringUtils.isNotEmpty(methodsString)) {
            String[] methods = methodsString.split(",");
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                String key = entry.getKey();
                for (String method : methods) {
                    String methodPrefix = method + '.';
                    if (!key.startsWith(methodPrefix)) continue;
                    String realKey = key.substring(methodPrefix.length());
                    URL.putMethodParameter(method, realKey, entry.getValue(), methodParameters);
                }
            }
        } else {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                String key = entry.getKey();
                int methodSeparator = key.indexOf(46);
                if (methodSeparator <= 0) continue;
                String method = key.substring(0, methodSeparator);
                String realKey = key.substring(methodSeparator + 1);
                URL.putMethodParameter(method, realKey, entry.getValue(), methodParameters);
            }
        }
        return methodParameters;
    }

    public Map<String, String> getParameters() {
        return this.params;
    }

    public URLParam addParameter(String key, String value) {
        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        if (value.equals(this.getParameters().get(key))) {
            return this;
        }
        HashMap<String, String> map = new HashMap<String, String>(this.getParameters());
        map.put(key, value);
        return new URLParam(map, this.rawParam);
    }

    public URLParam addParameterIfAbsent(String key, String value) {
        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        if (this.hasParameter(key)) {
            return this;
        }
        HashMap<String, String> map = new HashMap<String, String>(this.getParameters());
        map.put(key, value);
        return new URLParam(map, this.rawParam);
    }

    public URLParam addParameters(Map<String, String> parameters) {
        if (CollectionUtils.isEmptyMap(parameters)) {
            return this;
        }
        boolean hasAndEqual = true;
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String value = this.getParameters().get(entry.getKey());
            if (value == null) {
                if (entry.getValue() == null) continue;
                hasAndEqual = false;
                break;
            }
            if (value.equals(entry.getValue())) continue;
            hasAndEqual = false;
            break;
        }
        if (hasAndEqual) {
            return this;
        }
        HashMap<String, String> map = new HashMap<String, String>((int)((float)this.getParameters().size() + (float)parameters.size() / 0.75f) + 1);
        map.putAll(this.getParameters());
        map.putAll(parameters);
        return new URLParam(map, this.rawParam);
    }

    public URLParam addParametersIfAbsent(Map<String, String> parameters) {
        if (CollectionUtils.isEmptyMap(parameters)) {
            return this;
        }
        HashMap<String, String> map = new HashMap<String, String>((int)((float)this.getParameters().size() + (float)parameters.size() / 0.75f) + 1);
        map.putAll(parameters);
        map.putAll(this.getParameters());
        return new URLParam(map, this.rawParam);
    }

    public URLParam removeParameters(String ... keys) {
        if (keys == null || keys.length == 0) {
            return this;
        }
        HashMap<String, String> map = new HashMap<String, String>(this.getParameters());
        for (String key : keys) {
            map.remove(key);
        }
        if (map.size() == this.getParameters().size()) {
            return this;
        }
        return new URLParam(map, this.rawParam);
    }

    public URLParam clearParameters() {
        return new URLParam(new HashMap<String, String>());
    }

    public boolean hasParameter(String key) {
        String value = this.getParameter(key);
        return value != null && value.length() > 0;
    }

    public String getParameter(String key) {
        return this.params.get(key);
    }

    public String getRawParam() {
        return this.rawParam;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int hashCode() {
        return Objects.hash(this.params);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof URLParam)) {
            return false;
        }
        URLParam that = (URLParam)obj;
        return Objects.equals(this.getParameters(), that.getParameters());
    }

    public String toString() {
        if (StringUtils.isNotEmpty(this.rawParam)) {
            return this.rawParam;
        }
        if (this.params == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : new TreeMap<String, String>(this.params).entrySet()) {
            if (!StringUtils.isNotEmpty(entry.getKey())) continue;
            if (first) {
                first = false;
            } else {
                buf.append("&");
            }
            buf.append(entry.getKey());
            buf.append("=");
            buf.append(entry.getValue() == null ? "" : entry.getValue().trim());
        }
        return buf.toString();
    }

    public static URLParam parse(String rawParam, boolean encoded, Map<String, String> extraParameters) {
        Map<String, String> parameters = URLStrParser.parseParams(rawParam, encoded);
        if (CollectionUtils.isNotEmptyMap(extraParameters)) {
            parameters.putAll(extraParameters);
        }
        return new URLParam(parameters, rawParam);
    }

    public static URLParam parse(String rawParam) {
        String[] parts = rawParam.split("&");
        UnifiedMap parameters = new UnifiedMap((int)((float)parts.length / 0.75f) + 1);
        for (String part : parts) {
            if ((part = part.trim()).length() <= 0) continue;
            int j = part.indexOf(61);
            if (j >= 0) {
                String key = part.substring(0, j);
                String value = part.substring(j + 1);
                parameters.put(key, value);
                if (!key.startsWith("default.")) continue;
                parameters.putIfAbsent(key.substring("default.".length()), value);
                continue;
            }
            parameters.put(part, part);
        }
        return new URLParam((Map<String, String>)parameters, rawParam);
    }
}

