/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.context;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.dubbo.common.context.FrameworkExt;
import org.apache.dubbo.common.context.LifecycleAdapter;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfigBase;
import org.apache.dubbo.config.SslConfig;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ConfigManager
extends LifecycleAdapter
implements FrameworkExt {
    private static final Logger logger = LoggerFactory.getLogger(ConfigManager.class);
    public static final String NAME = "config";
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    final Map<String, Map<String, AbstractConfig>> configsCache = ConfigManager.newMap();
    private static volatile boolean configWarnLogEnabled = false;
    private static Map<String, Boolean> warnLogStatus = new ConcurrentHashMap<String, Boolean>();

    public ConfigManager() {
        try {
            String rawWarn = System.getProperty("dubbo.application.config.warn");
            if (rawWarn != null) {
                configWarnLogEnabled = Boolean.parseBoolean(rawWarn);
            }
        }
        catch (Exception e) {
            logger.warn("Illegal 'dubbo.application.config.warn'config, only boolean value is accepted.", e);
        }
    }

    public void setApplication(ApplicationConfig application) {
        this.addConfig(application, true);
    }

    public Optional<ApplicationConfig> getApplication() {
        return Optional.ofNullable(this.getConfig(AbstractConfig.getTagName(ApplicationConfig.class)));
    }

    public ApplicationConfig getApplicationOrElseThrow() {
        return this.getApplication().orElseThrow(() -> new IllegalStateException("There's no ApplicationConfig specified."));
    }

    public void setMonitor(MonitorConfig monitor) {
        this.addConfig(monitor, true);
    }

    public Optional<MonitorConfig> getMonitor() {
        return Optional.ofNullable(this.getConfig(AbstractConfig.getTagName(MonitorConfig.class)));
    }

    public void setModule(ModuleConfig module) {
        this.addConfig(module, true);
    }

    public Optional<ModuleConfig> getModule() {
        return Optional.ofNullable(this.getConfig(AbstractConfig.getTagName(ModuleConfig.class)));
    }

    public void setMetrics(MetricsConfig metrics) {
        this.addConfig(metrics, true);
    }

    public Optional<MetricsConfig> getMetrics() {
        return Optional.ofNullable(this.getConfig(AbstractConfig.getTagName(MetricsConfig.class)));
    }

    public void setSsl(SslConfig sslConfig) {
        this.addConfig(sslConfig, true);
    }

    public Optional<SslConfig> getSsl() {
        return Optional.ofNullable(this.getConfig(AbstractConfig.getTagName(SslConfig.class)));
    }

    public void addConfigCenter(ConfigCenterConfig configCenter) {
        this.addConfig(configCenter);
    }

    public void addConfigCenters(Iterable<ConfigCenterConfig> configCenters) {
        configCenters.forEach(this::addConfigCenter);
    }

    public Optional<Collection<ConfigCenterConfig>> getDefaultConfigCenter() {
        Collection<Object> defaults = ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(ConfigCenterConfig.class)));
        if (CollectionUtils.isEmpty(defaults)) {
            defaults = this.getConfigCenters();
        }
        return Optional.ofNullable(defaults);
    }

    public ConfigCenterConfig getConfigCenter(String id) {
        return (ConfigCenterConfig)this.getConfig(AbstractConfig.getTagName(ConfigCenterConfig.class), id);
    }

    public Collection<ConfigCenterConfig> getConfigCenters() {
        return this.getConfigs(AbstractConfig.getTagName(ConfigCenterConfig.class));
    }

    public void addMetadataReport(MetadataReportConfig metadataReportConfig) {
        this.addConfig(metadataReportConfig);
    }

    public void addMetadataReports(Iterable<MetadataReportConfig> metadataReportConfigs) {
        metadataReportConfigs.forEach(this::addMetadataReport);
    }

    public Collection<MetadataReportConfig> getMetadataConfigs() {
        return this.getConfigs(AbstractConfig.getTagName(MetadataReportConfig.class));
    }

    public Collection<MetadataReportConfig> getDefaultMetadataConfigs() {
        List<MetadataReportConfig> defaults = ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(MetadataReportConfig.class)));
        if (CollectionUtils.isEmpty(defaults)) {
            return this.getMetadataConfigs();
        }
        return defaults;
    }

    public void addProvider(ProviderConfig providerConfig) {
        this.addConfig(providerConfig);
    }

    public void addProviders(Iterable<ProviderConfig> providerConfigs) {
        providerConfigs.forEach(this::addProvider);
    }

    public Optional<ProviderConfig> getProvider(String id) {
        return Optional.ofNullable(this.getConfig(AbstractConfig.getTagName(ProviderConfig.class), id));
    }

    public Optional<ProviderConfig> getDefaultProvider() {
        List providerConfigs = ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(ProviderConfig.class)));
        if (CollectionUtils.isNotEmpty(providerConfigs)) {
            return Optional.of(providerConfigs.get(0));
        }
        return Optional.empty();
    }

    public Collection<ProviderConfig> getProviders() {
        return this.getConfigs(AbstractConfig.getTagName(ProviderConfig.class));
    }

    public void addConsumer(ConsumerConfig consumerConfig) {
        this.addConfig(consumerConfig);
    }

    public void addConsumers(Iterable<ConsumerConfig> consumerConfigs) {
        consumerConfigs.forEach(this::addConsumer);
    }

    public Optional<ConsumerConfig> getConsumer(String id) {
        return Optional.ofNullable(this.getConfig(AbstractConfig.getTagName(ConsumerConfig.class), id));
    }

    public Optional<ConsumerConfig> getDefaultConsumer() {
        List consumerConfigs = ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(ConsumerConfig.class)));
        if (CollectionUtils.isNotEmpty(consumerConfigs)) {
            return Optional.of(consumerConfigs.get(0));
        }
        return Optional.empty();
    }

    public Collection<ConsumerConfig> getConsumers() {
        return this.getConfigs(AbstractConfig.getTagName(ConsumerConfig.class));
    }

    public void addProtocol(ProtocolConfig protocolConfig) {
        this.addConfig(protocolConfig);
    }

    public void addProtocols(Iterable<ProtocolConfig> protocolConfigs) {
        if (protocolConfigs != null) {
            protocolConfigs.forEach(this::addProtocol);
        }
    }

    public Optional<ProtocolConfig> getProtocol(String id) {
        return Optional.ofNullable(this.getConfig(AbstractConfig.getTagName(ProtocolConfig.class), id));
    }

    public List<ProtocolConfig> getDefaultProtocols() {
        return ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(ProtocolConfig.class)));
    }

    public Collection<ProtocolConfig> getProtocols() {
        return this.getConfigs(AbstractConfig.getTagName(ProtocolConfig.class));
    }

    public Set<String> getProtocolIds() {
        HashSet<String> protocolIds = new HashSet<String>();
        protocolIds.addAll(ConfigManager.getSubProperties(ApplicationModel.getEnvironment().getExternalConfigurationMap(), "dubbo.protocols."));
        protocolIds.addAll(ConfigManager.getSubProperties(ApplicationModel.getEnvironment().getAppExternalConfigurationMap(), "dubbo.protocols."));
        return Collections.unmodifiableSet(protocolIds);
    }

    public void addRegistry(RegistryConfig registryConfig) {
        this.addConfig(registryConfig);
    }

    public void addRegistries(Iterable<RegistryConfig> registryConfigs) {
        if (registryConfigs != null) {
            registryConfigs.forEach(this::addRegistry);
        }
    }

    public Optional<RegistryConfig> getRegistry(String id) {
        return Optional.ofNullable(this.getConfig(AbstractConfig.getTagName(RegistryConfig.class), id));
    }

    public List<RegistryConfig> getDefaultRegistries() {
        return ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(RegistryConfig.class)));
    }

    public Collection<RegistryConfig> getRegistries() {
        return this.getConfigs(AbstractConfig.getTagName(RegistryConfig.class));
    }

    public Set<String> getRegistryIds() {
        HashSet<String> registryIds = new HashSet<String>();
        registryIds.addAll(ConfigManager.getSubProperties(ApplicationModel.getEnvironment().getExternalConfigurationMap(), "dubbo.registries."));
        registryIds.addAll(ConfigManager.getSubProperties(ApplicationModel.getEnvironment().getAppExternalConfigurationMap(), "dubbo.registries."));
        return Collections.unmodifiableSet(registryIds);
    }

    public void addService(ServiceConfigBase<?> serviceConfig) {
        this.addConfig(serviceConfig);
    }

    public void addServices(Iterable<ServiceConfigBase<?>> serviceConfigs) {
        serviceConfigs.forEach(this::addService);
    }

    public Collection<ServiceConfigBase> getServices() {
        return this.getConfigs(AbstractConfig.getTagName(ServiceConfigBase.class));
    }

    public <T> ServiceConfigBase<T> getService(String id) {
        return (ServiceConfigBase)this.getConfig(AbstractConfig.getTagName(ServiceConfigBase.class), id);
    }

    public void addReference(ReferenceConfigBase<?> referenceConfig) {
        this.addConfig(referenceConfig);
    }

    public void addReferences(Iterable<ReferenceConfigBase<?>> referenceConfigs) {
        referenceConfigs.forEach(this::addReference);
    }

    public Collection<ReferenceConfigBase<?>> getReferences() {
        return this.getConfigs(AbstractConfig.getTagName(ReferenceConfigBase.class));
    }

    public <T> ReferenceConfigBase<T> getReference(String id) {
        return (ReferenceConfigBase)this.getConfig(AbstractConfig.getTagName(ReferenceConfigBase.class), id);
    }

    protected static Set<String> getSubProperties(Map<String, String> properties, String prefix) {
        return properties.keySet().stream().filter(k -> k.contains(prefix)).map(k -> {
            k = k.substring(prefix.length());
            return k.substring(0, k.indexOf("."));
        }).collect(Collectors.toSet());
    }

    public void refreshAll() {
        this.write(() -> {
            this.getApplication().ifPresent(ApplicationConfig::refresh);
            this.getMonitor().ifPresent(AbstractConfig::refresh);
            this.getModule().ifPresent(AbstractConfig::refresh);
            this.getProtocols().forEach(ProtocolConfig::refresh);
            this.getRegistries().forEach(RegistryConfig::refresh);
            this.getProviders().forEach(AbstractConfig::refresh);
            this.getConsumers().forEach(AbstractConfig::refresh);
        });
    }

    public void removeConfig(AbstractConfig config) {
        if (config == null) {
            return;
        }
        Map<String, AbstractConfig> configs = this.configsCache.get(AbstractConfig.getTagName(config.getClass()));
        if (CollectionUtils.isNotEmptyMap(configs)) {
            configs.remove(ConfigManager.getId(config));
        }
    }

    public void clear() {
        this.write(() -> this.configsCache.clear());
    }

    @Override
    public void destroy() throws IllegalStateException {
        this.clear();
    }

    public void addConfig(AbstractConfig config) {
        this.addConfig(config, false);
    }

    protected void addConfig(AbstractConfig config, boolean unique) {
        if (config == null) {
            return;
        }
        this.write(() -> {
            Map configsMap = this.configsCache.computeIfAbsent(AbstractConfig.getTagName(config.getClass()), type -> ConfigManager.newMap());
            ConfigManager.addIfAbsent(config, configsMap, unique);
        });
    }

    protected <C extends AbstractConfig> Map<String, C> getConfigsMap(String configType) {
        return this.read(() -> this.configsCache.getOrDefault(configType, Collections.emptyMap()));
    }

    protected <C extends AbstractConfig> Collection<C> getConfigs(String configType) {
        return this.read(() -> this.getConfigsMap(configType).values());
    }

    protected <C extends AbstractConfig> C getConfig(String configType, String id) {
        return (C)this.read(() -> {
            Map configsMap = this.configsCache.getOrDefault(configType, Collections.emptyMap());
            return (AbstractConfig)configsMap.get(id);
        });
    }

    protected <C extends AbstractConfig> C getConfig(String configType) throws IllegalStateException {
        return (C)this.read(() -> {
            Map configsMap = this.configsCache.getOrDefault(configType, Collections.emptyMap());
            int size = configsMap.size();
            if (size < 1) {
                return null;
            }
            if (size > 1 && configWarnLogEnabled && warnLogStatus.get(configType) == null) {
                logger.warn("Expected single matching of " + configType + ", but found " + size + " instances, will randomly pick the first one.");
                warnLogStatus.put(configType, true);
            }
            return (AbstractConfig)configsMap.values().iterator().next();
        });
    }

    private <V> V write(Callable<V> callable) {
        V value = null;
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            value = callable.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getCause());
        }
        finally {
            writeLock.unlock();
        }
        return value;
    }

    private void write(Runnable runnable) {
        this.write(() -> {
            runnable.run();
            return null;
        });
    }

    private <V> V read(Callable<V> callable) {
        Lock readLock = this.lock.readLock();
        V value = null;
        try {
            readLock.lock();
            value = callable.call();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            readLock.unlock();
        }
        return value;
    }

    private static void checkDuplicate(AbstractConfig oldOne, AbstractConfig newOne) throws IllegalStateException {
        if (oldOne != null && !oldOne.equals(newOne)) {
            String configName = oldOne.getClass().getSimpleName();
            if (configWarnLogEnabled) {
                logger.warn("Duplicate Config found for " + configName + ", only one unique " + configName + " is allowed for one application.");
            }
        }
    }

    private static Map newMap() {
        return new HashMap();
    }

    static <C extends AbstractConfig> void addIfAbsent(C config, Map<String, C> configsMap, boolean unique) throws IllegalStateException {
        String key;
        AbstractConfig existedConfig;
        if (config == null || configsMap == null) {
            return;
        }
        if (unique) {
            configsMap.values().forEach(c -> ConfigManager.checkDuplicate(c, config));
        }
        if ((existedConfig = (AbstractConfig)configsMap.get(key = ConfigManager.getId(config))) != null && !config.equals(existedConfig)) {
            if (configWarnLogEnabled && logger.isWarnEnabled()) {
                String type = config.getClass().getSimpleName();
                logger.warn(String.format("Duplicate %s found, there already has one default %s or more than two %ss have the same id, you can try to give each %s a different id : %s", type, type, type, type, config));
            }
        } else {
            configsMap.put(key, config);
        }
    }

    static <C extends AbstractConfig> String getId(C config) {
        String id = config.getId();
        return StringUtils.isNotEmpty(id) ? id : (ConfigManager.isDefaultConfig(config) ? config.getClass().getSimpleName() + "#" + "default" : null);
    }

    static <C extends AbstractConfig> boolean isDefaultConfig(C config) {
        Boolean isDefault = (Boolean)ReflectUtils.getProperty(config, "isDefault");
        return isDefault == null || Boolean.TRUE.equals(isDefault);
    }

    static <C extends AbstractConfig> List<C> getDefaultConfigs(Map<String, C> configsMap) {
        return configsMap.values().stream().filter(ConfigManager::isDefaultConfig).collect(Collectors.toList());
    }
}

