/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.support;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.utils.StringUtils;

public class GroupServiceKeyCache {
    private final String serviceGroup;
    private final ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<Integer, String>>> serviceKeyMap;

    public GroupServiceKeyCache(String serviceGroup) {
        this.serviceGroup = serviceGroup;
        this.serviceKeyMap = new ConcurrentHashMap<String, ConcurrentMap<String, ConcurrentMap<Integer, String>>>(512);
    }

    public String getServiceKey(String serviceName, String serviceVersion, int port) {
        String serviceKey;
        ConcurrentMap portMap;
        ConcurrentMap versionMap = (ConcurrentMap)this.serviceKeyMap.get(serviceName);
        if (versionMap == null) {
            this.serviceKeyMap.putIfAbsent(serviceName, new ConcurrentHashMap());
            versionMap = (ConcurrentMap)this.serviceKeyMap.get(serviceName);
        }
        if ((portMap = (ConcurrentMap)versionMap.get(serviceVersion = serviceVersion == null ? "" : serviceVersion)) == null) {
            versionMap.putIfAbsent(serviceVersion, new ConcurrentHashMap());
            portMap = (ConcurrentMap)versionMap.get(serviceVersion);
        }
        if ((serviceKey = (String)portMap.get(port)) == null) {
            serviceKey = this.createServiceKey(serviceName, serviceVersion, port);
            portMap.put(port, serviceKey);
        }
        return serviceKey;
    }

    private String createServiceKey(String serviceName, String serviceVersion, int port) {
        StringBuilder buf = new StringBuilder();
        if (StringUtils.isNotEmpty(this.serviceGroup)) {
            buf.append(this.serviceGroup).append('/');
        }
        buf.append(serviceName);
        if (StringUtils.isNotEmpty(serviceVersion) && !"0.0.0".equals(serviceVersion)) {
            buf.append(':').append(serviceVersion);
        }
        buf.append(':').append(port);
        return buf.toString();
    }
}

