/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.json;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import org.apache.dubbo.common.utils.ClassUtils;

public class GsonUtils {
    private static volatile Object gsonCache = null;
    private static volatile Boolean supportGson;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSupportGson() {
        if (supportGson != null) return supportGson;
        Class<GsonUtils> clazz = GsonUtils.class;
        synchronized (GsonUtils.class) {
            if (supportGson != null) return supportGson;
            try {
                Class<?> aClass = ClassUtils.forName("com.google.gson.Gson");
                supportGson = aClass != null;
            }
            catch (Throwable t) {
                supportGson = false;
            }
            return supportGson;
        }
    }

    public static Object fromJson(String json, Type originType) throws RuntimeException {
        if (!GsonUtils.isSupportGson()) {
            throw new RuntimeException("Gson is not supported. Please import Gson in JVM env.");
        }
        Type type = TypeToken.get((Type)originType).getType();
        try {
            return GsonUtils.getGson().fromJson(json, type);
        }
        catch (JsonSyntaxException ex) {
            throw new RuntimeException(String.format("Generic serialization [%s] Json syntax exception thrown when parsing (message:%s type:%s) error:%s", "gson", json, type.toString(), ex.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Gson getGson() {
        if (gsonCache != null && gsonCache instanceof Gson) return (Gson)gsonCache;
        Class<GsonUtils> clazz = GsonUtils.class;
        synchronized (GsonUtils.class) {
            if (gsonCache != null && gsonCache instanceof Gson) return (Gson)gsonCache;
            gsonCache = new Gson();
            // ** MonitorExit[var0] (shouldn't be in output)
            return (Gson)gsonCache;
        }
    }

    @Deprecated
    protected static void setSupportGson(Boolean supportGson) {
        GsonUtils.supportGson = supportGson;
    }
}

