/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.BuiltinServiceDetector;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ProviderModel;

public class ServiceRepository {
    public static final String NAME = "repository";
    private AtomicBoolean inited = new AtomicBoolean(false);
    private ApplicationModel applicationModel;

    public ServiceRepository(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.initialize();
    }

    private void initialize() {
        Set<BuiltinServiceDetector> builtinServices;
        if (this.inited.compareAndSet(false, true) && CollectionUtils.isNotEmpty(builtinServices = this.applicationModel.getExtensionLoader(BuiltinServiceDetector.class).getSupportedExtensionInstances())) {
            for (BuiltinServiceDetector service : builtinServices) {
                this.applicationModel.getInternalModule().getServiceRepository().registerService(service.getService());
            }
        }
    }

    public void destroy() {
    }

    public Collection<ConsumerModel> allConsumerModels() {
        ArrayList<ConsumerModel> allConsumerModels = new ArrayList<ConsumerModel>();
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            allConsumerModels.addAll(moduleModel.getServiceRepository().getReferredServices());
        }
        return allConsumerModels;
    }

    public Collection<ProviderModel> allProviderModels() {
        ArrayList<ProviderModel> allProviderModels = new ArrayList<ProviderModel>();
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            allProviderModels.addAll(moduleModel.getServiceRepository().getExportedServices());
        }
        return allProviderModels;
    }
}

