/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.io.UnsafeStringWriter;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.common.utils.ReflectUtils;

public final class StringUtils {
    public static final String EMPTY_STRING = "";
    public static final int INDEX_NOT_FOUND = -1;
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Logger logger = LoggerFactory.getLogger(StringUtils.class);
    private static final Pattern KVP_PATTERN = Pattern.compile("([_.a-zA-Z0-9][-_.a-zA-Z0-9]*)[=](.*)");
    private static final Pattern NUM_PATTERN = Pattern.compile("^\\d+$");
    private static final Pattern PARAMETERS_PATTERN = Pattern.compile("^\\[((\\s*\\{\\s*[\\w_\\-\\.]+\\s*:\\s*.+?\\s*\\}\\s*,?\\s*)+)\\s*\\]$");
    private static final Pattern PAIR_PARAMETERS_PATTERN = Pattern.compile("^\\{\\s*([\\w-_\\.]+)\\s*:\\s*(.+)\\s*\\}$");
    private static final int PAD_LIMIT = 8192;
    private static final byte[] HEX2B;
    public static final char EQUAL_CHAR = '=';
    public static final String EQUAL;
    public static final char AND_CHAR = '&';
    public static final String AND;
    public static final char SEMICOLON_CHAR = ';';
    public static final String SEMICOLON;
    public static final char QUESTION_MASK_CHAR = '?';
    public static final String QUESTION_MASK;
    public static final char SLASH_CHAR = '/';
    public static final String SLASH;
    public static final char HYPHEN_CHAR = '-';
    public static final String HYPHEN;

    private StringUtils() {
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static String repeat(String str, int repeat) {
        if (str == null) {
            return null;
        }
        if (repeat <= 0) {
            return EMPTY_STRING;
        }
        int inputLength = str.length();
        if (repeat == 1 || inputLength == 0) {
            return str;
        }
        if (inputLength == 1 && repeat <= 8192) {
            return StringUtils.repeat(str.charAt(0), repeat);
        }
        int outputLength = inputLength * repeat;
        switch (inputLength) {
            case 1: {
                return StringUtils.repeat(str.charAt(0), repeat);
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char[] output2 = new char[outputLength];
                for (int i = repeat * 2 - 2; i >= 0; --i) {
                    output2[i] = ch0;
                    output2[i + 1] = ch1;
                    --i;
                }
                return new String(output2);
            }
        }
        StringBuilder buf = new StringBuilder(outputLength);
        for (int i = 0; i < repeat; ++i) {
            buf.append(str);
        }
        return buf.toString();
    }

    public static String repeat(String str, String separator, int repeat) {
        if (str == null || separator == null) {
            return StringUtils.repeat(str, repeat);
        }
        String result = StringUtils.repeat(str + separator, repeat);
        return StringUtils.removeEnd(result, separator);
    }

    public static String removeEnd(String str, String remove) {
        if (StringUtils.isAnyEmpty(str, remove)) {
            return str;
        }
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static String repeat(char ch, int repeat) {
        char[] buf = new char[repeat];
        for (int i = repeat - 1; i >= 0; --i) {
            buf[i] = ch;
        }
        return new String(buf);
    }

    public static String stripEnd(String str, String stripChars) {
        int end;
        if (str == null || (end = str.length()) == 0) {
            return str;
        }
        if (stripChars == null) {
            while (end != 0 && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
        } else {
            if (stripChars.isEmpty()) {
                return str;
            }
            while (end != 0 && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return str.substring(0, end);
    }

    public static String replace(String text, String searchString, String replacement) {
        return StringUtils.replace(text, searchString, replacement, -1);
    }

    public static String replace(String text, String searchString, String replacement, int max) {
        if (StringUtils.isAnyEmpty(text, searchString) || replacement == null || max == 0) {
            return text;
        }
        int start = 0;
        int end = text.indexOf(searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuilder buf = new StringBuilder(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != -1) {
            buf.append(text, start, end).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = text.indexOf(searchString, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static boolean hasText(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNoneEmpty(String ... ss) {
        if (ArrayUtils.isEmpty(ss)) {
            return false;
        }
        for (String s : ss) {
            if (!StringUtils.isEmpty(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyEmpty(String ... ss) {
        return !StringUtils.isNoneEmpty(ss);
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean isEquals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean isNumber(String str) {
        return StringUtils.isNotEmpty(str) && NUM_PATTERN.matcher(str).matches();
    }

    public static int parseInteger(String str) {
        return StringUtils.isNumber(str) ? Integer.parseInt(str) : 0;
    }

    public static long parseLong(String str) {
        return StringUtils.isNumber(str) ? Long.parseLong(str) : 0L;
    }

    public static boolean isJavaIdentifier(String s) {
        if (StringUtils.isEmpty(s) || !Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isContains(String values, String value) {
        return StringUtils.isNotEmpty(values) && StringUtils.isContains(CommonConstants.COMMA_SPLIT_PATTERN.split(values), value);
    }

    public static boolean isContains(String str, char ch) {
        return StringUtils.isNotEmpty(str) && str.indexOf(ch) >= 0;
    }

    public static boolean isNotContains(String str, char ch) {
        return !StringUtils.isContains(str, ch);
    }

    public static boolean isContains(String[] values, String value) {
        if (StringUtils.isNotEmpty(value) && ArrayUtils.isNotEmpty(values)) {
            for (String v : values) {
                if (!value.equals(v)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNumeric(String str, boolean allowDot) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        boolean hasDot = false;
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (str.charAt(i) == '.') {
                if (hasDot || !allowDot) {
                    return false;
                }
                hasDot = true;
                continue;
            }
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Throwable e) {
        UnsafeStringWriter w = new UnsafeStringWriter();
        PrintWriter p = new PrintWriter(w);
        p.print(e.getClass().getName());
        if (e.getMessage() != null) {
            p.print(": " + e.getMessage());
        }
        p.println();
        try {
            e.printStackTrace(p);
            String string = w.toString();
            return string;
        }
        finally {
            p.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String msg, Throwable e) {
        UnsafeStringWriter w = new UnsafeStringWriter();
        w.write(msg + "\n");
        try (PrintWriter p = new PrintWriter(w);){
            e.printStackTrace(p);
            String string = w.toString();
            return string;
        }
    }

    public static String translate(String src, String from, String to) {
        if (StringUtils.isEmpty(src)) {
            return src;
        }
        StringBuilder sb = null;
        int len = src.length();
        for (int i = 0; i < len; ++i) {
            char c = src.charAt(i);
            int ix = from.indexOf(c);
            if (ix == -1) {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder(len);
                sb.append(src, 0, i);
            }
            if (ix >= to.length()) continue;
            sb.append(to.charAt(ix));
        }
        return sb == null ? src : sb.toString();
    }

    public static String[] split(String str, char ch) {
        if (StringUtils.isEmpty(str)) {
            return EMPTY_STRING_ARRAY;
        }
        return StringUtils.splitToList0(str, ch).toArray(EMPTY_STRING_ARRAY);
    }

    private static List<String> splitToList0(String str, char ch) {
        ArrayList<String> result = new ArrayList<String>();
        int ix = 0;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) != ch) continue;
            result.add(str.substring(ix, i));
            ix = i + 1;
        }
        if (ix >= 0) {
            result.add(str.substring(ix));
        }
        return result;
    }

    public static List<String> splitToList(String str, char ch) {
        if (StringUtils.isEmpty(str)) {
            return Collections.emptyList();
        }
        return StringUtils.splitToList0(str, ch);
    }

    public static Set<String> splitToSet(String value, char separatorChar) {
        return StringUtils.splitToSet(value, separatorChar, false);
    }

    public static Set<String> splitToSet(String value, char separatorChar, boolean trimElements) {
        List<String> values = StringUtils.splitToList(value, separatorChar);
        int size = values.size();
        if (size < 1) {
            return Collections.emptySet();
        }
        if (!trimElements) {
            return new LinkedHashSet<String>(values);
        }
        return Collections.unmodifiableSet(values.stream().map(String::trim).collect(LinkedHashSet::new, Set::add, Set::addAll));
    }

    public static String join(String[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : array) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String join(String[] array, char split) {
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(split);
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static String join(String[] array, String split) {
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(split);
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static String join(Collection<String> coll, String split) {
        if (CollectionUtils.isEmpty(coll)) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (String s : coll) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(split);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private static Map<String, String> parseKeyValuePair(String str, String itemSeparator) {
        String[] tmp = str.split(itemSeparator);
        HashMap<String, String> map = new HashMap<String, String>(tmp.length);
        for (int i = 0; i < tmp.length; ++i) {
            Matcher matcher = KVP_PATTERN.matcher(tmp[i]);
            if (!matcher.matches()) continue;
            map.put(matcher.group(1), matcher.group(2));
        }
        return map;
    }

    public static String getQueryStringValue(String qs, String key) {
        Map<String, String> map = StringUtils.parseQueryString(qs);
        return map.get(key);
    }

    public static Map<String, String> parseQueryString(String qs) {
        if (StringUtils.isEmpty(qs)) {
            return new HashMap<String, String>();
        }
        return StringUtils.parseKeyValuePair(qs, "\\&");
    }

    public static String getServiceKey(Map<String, String> ps) {
        StringBuilder buf = new StringBuilder();
        String group = ps.get("group");
        if (StringUtils.isNotEmpty(group)) {
            buf.append(group).append('/');
        }
        buf.append(ps.get("interface"));
        String version = ps.get("version");
        if (StringUtils.isNotEmpty(group)) {
            buf.append(':').append(version);
        }
        return buf.toString();
    }

    public static String toQueryString(Map<String, String> ps) {
        StringBuilder buf = new StringBuilder();
        if (ps != null && ps.size() > 0) {
            for (Map.Entry<String, String> entry : new TreeMap<String, String>(ps).entrySet()) {
                String value;
                String key = entry.getKey();
                if (!StringUtils.isNoneEmpty(key, value = entry.getValue())) continue;
                if (buf.length() > 0) {
                    buf.append('&');
                }
                buf.append(key);
                buf.append('=');
                buf.append(value);
            }
        }
        return buf.toString();
    }

    public static String camelToSplitName(String camelName, String split) {
        if (StringUtils.isEmpty(camelName)) {
            return camelName;
        }
        if (!StringUtils.isWord(camelName)) {
            if (StringUtils.isSplitCase(camelName, split.charAt(0))) {
                return camelName.toLowerCase();
            }
            return camelName;
        }
        StringBuilder buf = null;
        for (int i = 0; i < camelName.length(); ++i) {
            char ch = camelName.charAt(i);
            if (ch >= 'A' && ch <= 'Z') {
                if (buf == null) {
                    buf = new StringBuilder();
                    if (i > 0) {
                        buf.append(camelName, 0, i);
                    }
                }
                if (i > 0) {
                    buf.append(split);
                }
                buf.append(Character.toLowerCase(ch));
                continue;
            }
            if (buf == null) continue;
            buf.append(ch);
        }
        return buf == null ? camelName.toLowerCase() : buf.toString().toLowerCase();
    }

    private static boolean isSplitCase(String str, char separator) {
        if (str == null) {
            return false;
        }
        return str.chars().allMatch(ch -> ch == separator || StringUtils.isWord((char)ch));
    }

    private static boolean isWord(String str) {
        if (str == null) {
            return false;
        }
        return str.chars().allMatch(ch -> StringUtils.isWord((char)ch));
    }

    private static boolean isWord(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9';
    }

    public static String snakeToSplitName(String snakeName, String split) {
        String lowerCase = snakeName.toLowerCase();
        if (StringUtils.isSnakeCase(snakeName)) {
            return StringUtils.replace(lowerCase, "_", split);
        }
        return snakeName;
    }

    protected static boolean isSnakeCase(String str) {
        return str.contains("_") || str.equals(str.toLowerCase()) || str.equals(str.toUpperCase());
    }

    public static String convertToSplitName(String str, String split) {
        if (StringUtils.isSnakeCase(str)) {
            return StringUtils.snakeToSplitName(str, split);
        }
        return StringUtils.camelToSplitName(str, split);
    }

    public static String toArgumentString(Object[] args) {
        StringBuilder buf = new StringBuilder();
        for (Object arg : args) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            if (arg == null || ReflectUtils.isPrimitives(arg.getClass())) {
                buf.append(arg);
                continue;
            }
            try {
                buf.append(JsonUtils.getJson().toJson(arg));
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), e);
                buf.append(arg);
            }
        }
        return buf.toString();
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String toURLKey(String key) {
        return key.toLowerCase().replaceAll("_|-", ".");
    }

    public static String toOSStyleKey(String key) {
        if (!(key = key.toUpperCase().replaceAll("\\.", "_")).startsWith("DUBBO_")) {
            key = "DUBBO_" + key;
        }
        return key;
    }

    public static boolean isAllUpperCase(String str) {
        if (str != null && !StringUtils.isEmpty(str)) {
            int sz = str.length();
            for (int i = 0; i < sz; ++i) {
                if (Character.isUpperCase(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String[] delimitedListToStringArray(String str, String delimiter) {
        return StringUtils.delimitedListToStringArray(str, delimiter, null);
    }

    public static String[] delimitedListToStringArray(String str, String delimiter, String charsToDelete) {
        if (str == null) {
            return new String[0];
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        ArrayList<String> result = new ArrayList<String>();
        if (EMPTY_STRING.equals(delimiter)) {
            for (int pos = 0; pos < str.length(); ++pos) {
                result.add(StringUtils.deleteAny(str.substring(pos, pos + 1), charsToDelete));
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(StringUtils.deleteAny(str.substring(pos, delPos), charsToDelete));
                pos = delPos + delimiter.length();
            }
            if (str.length() > 0 && pos <= str.length()) {
                result.add(StringUtils.deleteAny(str.substring(pos), charsToDelete));
            }
        }
        return StringUtils.toStringArray(result);
    }

    public static String arrayToDelimitedString(Object[] arr, String delim) {
        if (ArrayUtils.isEmpty(arr)) {
            return EMPTY_STRING;
        }
        if (arr.length == 1) {
            return StringUtils.nullSafeToString(arr[0]);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public static String deleteAny(String inString, String charsToDelete) {
        if (StringUtils.isNotEmpty(inString) && StringUtils.isNotEmpty(charsToDelete)) {
            StringBuilder sb = new StringBuilder(inString.length());
            for (int i = 0; i < inString.length(); ++i) {
                char c = inString.charAt(i);
                if (charsToDelete.indexOf(c) != -1) continue;
                sb.append(c);
            }
            return sb.toString();
        }
        return inString;
    }

    public static String[] toStringArray(Collection<String> collection) {
        return collection.toArray(new String[0]);
    }

    public static String nullSafeToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        String str = obj.toString();
        return str != null ? str : EMPTY_STRING;
    }

    public static Map<String, String> parseParameters(String rawParameters) {
        if (StringUtils.isBlank(rawParameters)) {
            return Collections.emptyMap();
        }
        Matcher matcher = PARAMETERS_PATTERN.matcher(rawParameters);
        if (!matcher.matches()) {
            return Collections.emptyMap();
        }
        String pairs = matcher.group(1);
        String[] pairArr = pairs.split("\\s*,\\s*");
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String pair : pairArr) {
            Matcher pairMatcher = PAIR_PARAMETERS_PATTERN.matcher(pair);
            if (!pairMatcher.matches()) continue;
            parameters.put(pairMatcher.group(1), pairMatcher.group(2));
        }
        return parameters;
    }

    public static String encodeParameters(Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        params.forEach((key, value) -> {
            if (StringUtils.hasText(value)) {
                sb.append('{').append((String)key).append(':').append((String)value).append("},");
            }
        });
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(']');
        return sb.toString();
    }

    public static int decodeHexNibble(char c) {
        byte[] hex2b = HEX2B;
        return c < hex2b.length ? hex2b[c] : -1;
    }

    public static byte decodeHexByte(CharSequence s, int pos) {
        int hi = StringUtils.decodeHexNibble(s.charAt(pos));
        int lo = StringUtils.decodeHexNibble(s.charAt(pos + 1));
        if (hi == -1 || lo == -1) {
            throw new IllegalArgumentException(String.format("invalid hex byte '%s' at index %d of '%s'", s.subSequence(pos, pos + 2), pos, s));
        }
        return (byte)((hi << 4) + lo);
    }

    public static String toCommaDelimitedString(String one, String ... others) {
        String another = StringUtils.arrayToDelimitedString(others, ",");
        return StringUtils.isEmpty(another) ? one : one + "," + another;
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        if (str == null || prefix == null || str.length() < prefix.length()) {
            return false;
        }
        return str.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    static {
        EQUAL = String.valueOf('=');
        AND = String.valueOf('&');
        SEMICOLON = String.valueOf(';');
        QUESTION_MASK = String.valueOf('?');
        SLASH = String.valueOf('/');
        HYPHEN = String.valueOf('-');
        HEX2B = new byte[128];
        Arrays.fill(HEX2B, (byte)-1);
        StringUtils.HEX2B[48] = 0;
        StringUtils.HEX2B[49] = 1;
        StringUtils.HEX2B[50] = 2;
        StringUtils.HEX2B[51] = 3;
        StringUtils.HEX2B[52] = 4;
        StringUtils.HEX2B[53] = 5;
        StringUtils.HEX2B[54] = 6;
        StringUtils.HEX2B[55] = 7;
        StringUtils.HEX2B[56] = 8;
        StringUtils.HEX2B[57] = 9;
        StringUtils.HEX2B[65] = 10;
        StringUtils.HEX2B[66] = 11;
        StringUtils.HEX2B[67] = 12;
        StringUtils.HEX2B[68] = 13;
        StringUtils.HEX2B[69] = 14;
        StringUtils.HEX2B[70] = 15;
        StringUtils.HEX2B[97] = 10;
        StringUtils.HEX2B[98] = 11;
        StringUtils.HEX2B[99] = 12;
        StringUtils.HEX2B[100] = 13;
        StringUtils.HEX2B[101] = 14;
        StringUtils.HEX2B[102] = 15;
    }
}

